/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.NodeCategory;
import software.amazon.awssdk.services.panorama.model.PanoramaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNodesRequest
extends PanoramaRequest
implements ToCopyableBuilder<Builder, ListNodesRequest> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(ListNodesRequest.getter(ListNodesRequest::categoryAsString)).setter(ListNodesRequest.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("category").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListNodesRequest.getter(ListNodesRequest::maxResults)).setter(ListNodesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNodesRequest.getter(ListNodesRequest::nextToken)).setter(ListNodesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccount").getter(ListNodesRequest.getter(ListNodesRequest::ownerAccount)).setter(ListNodesRequest.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ownerAccount").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(ListNodesRequest.getter(ListNodesRequest::packageName)).setter(ListNodesRequest.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("packageName").build()}).build();
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageVersion").getter(ListNodesRequest.getter(ListNodesRequest::packageVersion)).setter(ListNodesRequest.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("packageVersion").build()}).build();
    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatchVersion").getter(ListNodesRequest.getter(ListNodesRequest::patchVersion)).setter(ListNodesRequest.setter(Builder::patchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("patchVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OWNER_ACCOUNT_FIELD, PACKAGE_NAME_FIELD, PACKAGE_VERSION_FIELD, PATCH_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("category", CATEGORY_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("ownerAccount", OWNER_ACCOUNT_FIELD);
            this.put("packageName", PACKAGE_NAME_FIELD);
            this.put("packageVersion", PACKAGE_VERSION_FIELD);
            this.put("patchVersion", PATCH_VERSION_FIELD);
        }
    });
    private final String category;
    private final Integer maxResults;
    private final String nextToken;
    private final String ownerAccount;
    private final String packageName;
    private final String packageVersion;
    private final String patchVersion;

    private ListNodesRequest(BuilderImpl builder) {
        super(builder);
        this.category = builder.category;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ownerAccount = builder.ownerAccount;
        this.packageName = builder.packageName;
        this.packageVersion = builder.packageVersion;
        this.patchVersion = builder.patchVersion;
    }

    public final NodeCategory category() {
        return NodeCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final String patchVersion() {
        return this.patchVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNodesRequest)) {
            return false;
        }
        ListNodesRequest other = (ListNodesRequest)((Object)obj);
        return Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.patchVersion(), other.patchVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ListNodesRequest").add("Category", (Object)this.categoryAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OwnerAccount", (Object)this.ownerAccount()).add("PackageName", (Object)this.packageName()).add("PackageVersion", (Object)this.packageVersion()).add("PatchVersion", (Object)this.patchVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "PatchVersion": {
                return Optional.ofNullable(clazz.cast(this.patchVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListNodesRequest, T> g) {
        return obj -> g.apply((ListNodesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaRequest.BuilderImpl
    implements Builder {
        private String category;
        private Integer maxResults;
        private String nextToken;
        private String ownerAccount;
        private String packageName;
        private String packageVersion;
        private String patchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNodesRequest model) {
            super(model);
            this.category(model.category);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.ownerAccount(model.ownerAccount);
            this.packageName(model.packageName);
            this.packageVersion(model.packageVersion);
            this.patchVersion(model.patchVersion);
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(NodeCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPatchVersion() {
            return this.patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNodesRequest build() {
            return new ListNodesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PanoramaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNodesRequest> {
        public Builder category(String var1);

        public Builder category(NodeCategory var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder ownerAccount(String var1);

        public Builder packageName(String var1);

        public Builder packageVersion(String var1);

        public Builder patchVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

