/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.PanoramaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNodeRequest
extends PanoramaRequest
implements ToCopyableBuilder<Builder, DescribeNodeRequest> {
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(DescribeNodeRequest.getter(DescribeNodeRequest::nodeId)).setter(DescribeNodeRequest.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("NodeId").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccount").getter(DescribeNodeRequest.getter(DescribeNodeRequest::ownerAccount)).setter(DescribeNodeRequest.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OwnerAccount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ID_FIELD, OWNER_ACCOUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NodeId", NODE_ID_FIELD);
            this.put("OwnerAccount", OWNER_ACCOUNT_FIELD);
        }
    });
    private final String nodeId;
    private final String ownerAccount;

    private DescribeNodeRequest(BuilderImpl builder) {
        super(builder);
        this.nodeId = builder.nodeId;
        this.ownerAccount = builder.ownerAccount;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeRequest)) {
            return false;
        }
        DescribeNodeRequest other = (DescribeNodeRequest)((Object)obj);
        return Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.ownerAccount(), other.ownerAccount());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNodeRequest").add("NodeId", (Object)this.nodeId()).add("OwnerAccount", (Object)this.ownerAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "OwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeRequest, T> g) {
        return obj -> g.apply((DescribeNodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaRequest.BuilderImpl
    implements Builder {
        private String nodeId;
        private String ownerAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeRequest model) {
            super(model);
            this.nodeId(model.nodeId);
            this.ownerAccount(model.ownerAccount);
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNodeRequest build() {
            return new DescribeNodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PanoramaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNodeRequest> {
        public Builder nodeId(String var1);

        public Builder ownerAccount(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

