/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaClient;
import software.amazon.awssdk.services.panorama.internal.UserAgentUtils;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse;

public class ListApplicationInstancesIterable
implements SdkIterable<ListApplicationInstancesResponse> {
    private final PanoramaClient client;
    private final ListApplicationInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationInstancesIterable(PanoramaClient client, ListApplicationInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationInstancesResponseFetcher();
    }

    public Iterator<ListApplicationInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListApplicationInstancesResponseFetcher
    implements SyncPageFetcher<ListApplicationInstancesResponse> {
        private ListApplicationInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationInstancesResponse nextPage(ListApplicationInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationInstancesIterable.this.client.listApplicationInstances(ListApplicationInstancesIterable.this.firstRequest);
            }
            return ListApplicationInstancesIterable.this.client.listApplicationInstances((ListApplicationInstancesRequest)((Object)ListApplicationInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

