/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.PortType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeInputPort
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeInputPort> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(NodeInputPort.getter(NodeInputPort::defaultValue)).setter(NodeInputPort.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(NodeInputPort.getter(NodeInputPort::description)).setter(NodeInputPort.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> MAX_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConnections").getter(NodeInputPort.getter(NodeInputPort::maxConnections)).setter(NodeInputPort.setter(Builder::maxConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConnections").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(NodeInputPort.getter(NodeInputPort::name)).setter(NodeInputPort.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(NodeInputPort.getter(NodeInputPort::typeAsString)).setter(NodeInputPort.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD, MAX_CONNECTIONS_FIELD, NAME_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String defaultValue;
    private final String description;
    private final Integer maxConnections;
    private final String name;
    private final String type;

    private NodeInputPort(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.maxConnections = builder.maxConnections;
        this.name = builder.name;
        this.type = builder.type;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String description() {
        return this.description;
    }

    public final Integer maxConnections() {
        return this.maxConnections;
    }

    public final String name() {
        return this.name;
    }

    public final PortType type() {
        return PortType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConnections());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInputPort)) {
            return false;
        }
        NodeInputPort other = (NodeInputPort)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.maxConnections(), other.maxConnections()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NodeInputPort").add("DefaultValue", (Object)this.defaultValue()).add("Description", (Object)this.description()).add("MaxConnections", (Object)this.maxConnections()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MaxConnections": {
                return Optional.ofNullable(clazz.cast(this.maxConnections()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeInputPort, T> g) {
        return obj -> g.apply((NodeInputPort)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private String description;
        private Integer maxConnections;
        private String name;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeInputPort model) {
            this.defaultValue(model.defaultValue);
            this.description(model.description);
            this.maxConnections(model.maxConnections);
            this.name(model.name);
            this.type(model.type);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getMaxConnections() {
            return this.maxConnections;
        }

        public final void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        @Override
        public final Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PortType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public NodeInputPort build() {
            return new NodeInputPort(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeInputPort> {
        public Builder defaultValue(String var1);

        public Builder description(String var1);

        public Builder maxConnections(Integer var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(PortType var1);
    }
}

