/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobResourceType {
    PACKAGE("PACKAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobResourceType> VALUE_MAP;
    private final String value;

    private JobResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobResourceType> knownValues() {
        EnumSet<JobResourceType> knownValues = EnumSet.allOf(JobResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobResourceType.class, JobResourceType::toString);
    }
}

