/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.PackageObject;
import software.amazon.awssdk.services.panorama.model.PackageObjectsCopier;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationInstanceDependenciesResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, ListApplicationInstanceDependenciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationInstanceDependenciesResponse.getter(ListApplicationInstanceDependenciesResponse::nextToken)).setter(ListApplicationInstanceDependenciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<PackageObject>> PACKAGE_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PackageObjects").getter(ListApplicationInstanceDependenciesResponse.getter(ListApplicationInstanceDependenciesResponse::packageObjects)).setter(ListApplicationInstanceDependenciesResponse.setter(Builder::packageObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageObjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PACKAGE_OBJECTS_FIELD));
    private final String nextToken;
    private final List<PackageObject> packageObjects;

    private ListApplicationInstanceDependenciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.packageObjects = builder.packageObjects;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPackageObjects() {
        return this.packageObjects != null && !(this.packageObjects instanceof SdkAutoConstructList);
    }

    public final List<PackageObject> packageObjects() {
        return this.packageObjects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackageObjects() ? this.packageObjects() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationInstanceDependenciesResponse)) {
            return false;
        }
        ListApplicationInstanceDependenciesResponse other = (ListApplicationInstanceDependenciesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPackageObjects() == other.hasPackageObjects() && Objects.equals(this.packageObjects(), other.packageObjects());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationInstanceDependenciesResponse").add("NextToken", (Object)this.nextToken()).add("PackageObjects", this.hasPackageObjects() ? this.packageObjects() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PackageObjects": {
                return Optional.ofNullable(clazz.cast(this.packageObjects()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationInstanceDependenciesResponse, T> g) {
        return obj -> g.apply((ListApplicationInstanceDependenciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PackageObject> packageObjects = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationInstanceDependenciesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.packageObjects(model.packageObjects);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PackageObject.Builder> getPackageObjects() {
            List<PackageObject.Builder> result = PackageObjectsCopier.copyToBuilder(this.packageObjects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageObjects(Collection<PackageObject.BuilderImpl> packageObjects) {
            this.packageObjects = PackageObjectsCopier.copyFromBuilder(packageObjects);
        }

        @Override
        @Transient
        public final Builder packageObjects(Collection<PackageObject> packageObjects) {
            this.packageObjects = PackageObjectsCopier.copy(packageObjects);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder packageObjects(PackageObject ... packageObjects) {
            this.packageObjects(Arrays.asList(packageObjects));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder packageObjects(Consumer<PackageObject.Builder> ... packageObjects) {
            this.packageObjects(Stream.of(packageObjects).map(c -> (PackageObject)((PackageObject.Builder)PackageObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListApplicationInstanceDependenciesResponse build() {
            return new ListApplicationInstanceDependenciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationInstanceDependenciesResponse> {
        public Builder nextToken(String var1);

        public Builder packageObjects(Collection<PackageObject> var1);

        public Builder packageObjects(PackageObject ... var1);

        public Builder packageObjects(Consumer<PackageObject.Builder> ... var1);
    }
}

