/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.JobResourceTags;
import software.amazon.awssdk.services.panorama.model.JobTagsListCopier;
import software.amazon.awssdk.services.panorama.model.PackageImportJobInputConfig;
import software.amazon.awssdk.services.panorama.model.PackageImportJobOutputConfig;
import software.amazon.awssdk.services.panorama.model.PackageImportJobType;
import software.amazon.awssdk.services.panorama.model.PanoramaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePackageImportJobRequest
extends PanoramaRequest
implements ToCopyableBuilder<Builder, CreatePackageImportJobRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreatePackageImportJobRequest.getter(CreatePackageImportJobRequest::clientToken)).setter(CreatePackageImportJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<PackageImportJobInputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(CreatePackageImportJobRequest.getter(CreatePackageImportJobRequest::inputConfig)).setter(CreatePackageImportJobRequest.setter(Builder::inputConfig)).constructor(PackageImportJobInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<List<JobResourceTags>> JOB_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobTags").getter(CreatePackageImportJobRequest.getter(CreatePackageImportJobRequest::jobTags)).setter(CreatePackageImportJobRequest.setter(Builder::jobTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobResourceTags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(CreatePackageImportJobRequest.getter(CreatePackageImportJobRequest::jobTypeAsString)).setter(CreatePackageImportJobRequest.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<PackageImportJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CreatePackageImportJobRequest.getter(CreatePackageImportJobRequest::outputConfig)).setter(CreatePackageImportJobRequest.setter(Builder::outputConfig)).constructor(PackageImportJobOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, INPUT_CONFIG_FIELD, JOB_TAGS_FIELD, JOB_TYPE_FIELD, OUTPUT_CONFIG_FIELD));
    private final String clientToken;
    private final PackageImportJobInputConfig inputConfig;
    private final List<JobResourceTags> jobTags;
    private final String jobType;
    private final PackageImportJobOutputConfig outputConfig;

    private CreatePackageImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.inputConfig = builder.inputConfig;
        this.jobTags = builder.jobTags;
        this.jobType = builder.jobType;
        this.outputConfig = builder.outputConfig;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final PackageImportJobInputConfig inputConfig() {
        return this.inputConfig;
    }

    public final boolean hasJobTags() {
        return this.jobTags != null && !(this.jobTags instanceof SdkAutoConstructList);
    }

    public final List<JobResourceTags> jobTags() {
        return this.jobTags;
    }

    public final PackageImportJobType jobType() {
        return PackageImportJobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final PackageImportJobOutputConfig outputConfig() {
        return this.outputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobTags() ? this.jobTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageImportJobRequest)) {
            return false;
        }
        CreatePackageImportJobRequest other = (CreatePackageImportJobRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.inputConfig(), other.inputConfig()) && this.hasJobTags() == other.hasJobTags() && Objects.equals(this.jobTags(), other.jobTags()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.outputConfig(), other.outputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePackageImportJobRequest").add("ClientToken", (Object)this.clientToken()).add("InputConfig", (Object)this.inputConfig()).add("JobTags", this.hasJobTags() ? this.jobTags() : null).add("JobType", (Object)this.jobTypeAsString()).add("OutputConfig", (Object)this.outputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "JobTags": {
                return Optional.ofNullable(clazz.cast(this.jobTags()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePackageImportJobRequest, T> g) {
        return obj -> g.apply((CreatePackageImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private PackageImportJobInputConfig inputConfig;
        private List<JobResourceTags> jobTags = DefaultSdkAutoConstructList.getInstance();
        private String jobType;
        private PackageImportJobOutputConfig outputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackageImportJobRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.inputConfig(model.inputConfig);
            this.jobTags(model.jobTags);
            this.jobType(model.jobType);
            this.outputConfig(model.outputConfig);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final PackageImportJobInputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(PackageImportJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder inputConfig(PackageImportJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final List<JobResourceTags.Builder> getJobTags() {
            List<JobResourceTags.Builder> result = JobTagsListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<JobResourceTags.BuilderImpl> jobTags) {
            this.jobTags = JobTagsListCopier.copyFromBuilder(jobTags);
        }

        @Override
        @Transient
        public final Builder jobTags(Collection<JobResourceTags> jobTags) {
            this.jobTags = JobTagsListCopier.copy(jobTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobTags(JobResourceTags ... jobTags) {
            this.jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobTags(Consumer<JobResourceTags.Builder> ... jobTags) {
            this.jobTags(Stream.of(jobTags).map(c -> (JobResourceTags)((JobResourceTags.Builder)JobResourceTags.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        @Transient
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        @Transient
        public final Builder jobType(PackageImportJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final PackageImportJobOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(PackageImportJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputConfig(PackageImportJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePackageImportJobRequest build() {
            return new CreatePackageImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PanoramaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePackageImportJobRequest> {
        public Builder clientToken(String var1);

        public Builder inputConfig(PackageImportJobInputConfig var1);

        default public Builder inputConfig(Consumer<PackageImportJobInputConfig.Builder> inputConfig) {
            return this.inputConfig((PackageImportJobInputConfig)((PackageImportJobInputConfig.Builder)PackageImportJobInputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder jobTags(Collection<JobResourceTags> var1);

        public Builder jobTags(JobResourceTags ... var1);

        public Builder jobTags(Consumer<JobResourceTags.Builder> ... var1);

        public Builder jobType(String var1);

        public Builder jobType(PackageImportJobType var1);

        public Builder outputConfig(PackageImportJobOutputConfig var1);

        default public Builder outputConfig(Consumer<PackageImportJobOutputConfig.Builder> outputConfig) {
            return this.outputConfig((PackageImportJobOutputConfig)((PackageImportJobOutputConfig.Builder)PackageImportJobOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

