/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationInstanceStatus {
    DEPLOYMENT_PENDING("DEPLOYMENT_PENDING"),
    DEPLOYMENT_REQUESTED("DEPLOYMENT_REQUESTED"),
    DEPLOYMENT_IN_PROGRESS("DEPLOYMENT_IN_PROGRESS"),
    DEPLOYMENT_ERROR("DEPLOYMENT_ERROR"),
    DEPLOYMENT_SUCCEEDED("DEPLOYMENT_SUCCEEDED"),
    REMOVAL_PENDING("REMOVAL_PENDING"),
    REMOVAL_REQUESTED("REMOVAL_REQUESTED"),
    REMOVAL_IN_PROGRESS("REMOVAL_IN_PROGRESS"),
    REMOVAL_FAILED("REMOVAL_FAILED"),
    REMOVAL_SUCCEEDED("REMOVAL_SUCCEEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationInstanceStatus> VALUE_MAP;
    private final String value;

    private ApplicationInstanceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationInstanceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationInstanceStatus> knownValues() {
        EnumSet<ApplicationInstanceStatus> knownValues = EnumSet.allOf(ApplicationInstanceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationInstanceStatus.class, ApplicationInstanceStatus::toString);
    }
}

