/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeInstanceStatus {
    RUNNING("RUNNING"),
    ERROR("ERROR"),
    NOT_AVAILABLE("NOT_AVAILABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeInstanceStatus> VALUE_MAP;
    private final String value;

    private NodeInstanceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeInstanceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeInstanceStatus> knownValues() {
        EnumSet<NodeInstanceStatus> knownValues = EnumSet.allOf(NodeInstanceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeInstanceStatus.class, NodeInstanceStatus::toString);
    }
}

