/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.PanoramaException;
import software.amazon.awssdk.services.panorama.model.ValidationExceptionErrorArgument;
import software.amazon.awssdk.services.panorama.model.ValidationExceptionErrorArgumentListCopier;
import software.amazon.awssdk.services.panorama.model.ValidationExceptionField;
import software.amazon.awssdk.services.panorama.model.ValidationExceptionFieldListCopier;
import software.amazon.awssdk.services.panorama.model.ValidationExceptionReason;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationException
extends PanoramaException
implements ToCopyableBuilder<Builder, ValidationException> {
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(ValidationException.getter(ValidationException::reasonAsString)).setter(ValidationException.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<String> ERROR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorId").getter(ValidationException.getter(ValidationException::errorId)).setter(ValidationException.setter(Builder::errorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorId").build()}).build();
    private static final SdkField<List<ValidationExceptionErrorArgument>> ERROR_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorArguments").getter(ValidationException.getter(ValidationException::errorArguments)).setter(ValidationException.setter(Builder::errorArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationExceptionErrorArgument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ValidationExceptionField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fields").getter(ValidationException.getter(ValidationException::fields)).setter(ValidationException.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationExceptionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, ERROR_ID_FIELD, ERROR_ARGUMENTS_FIELD, FIELDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reason;
    private final String errorId;
    private final List<ValidationExceptionErrorArgument> errorArguments;
    private final List<ValidationExceptionField> fields;

    private ValidationException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
        this.errorId = builder.errorId;
        this.errorArguments = builder.errorArguments;
        this.fields = builder.fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ValidationExceptionReason reason() {
        return ValidationExceptionReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    public String errorId() {
        return this.errorId;
    }

    public boolean hasErrorArguments() {
        return this.errorArguments != null && !(this.errorArguments instanceof SdkAutoConstructList);
    }

    public List<ValidationExceptionErrorArgument> errorArguments() {
        return this.errorArguments;
    }

    public boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public List<ValidationExceptionField> fields() {
        return this.fields;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationException, T> g) {
        return obj -> g.apply((ValidationException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaException.BuilderImpl
    implements Builder {
        private String reason;
        private String errorId;
        private List<ValidationExceptionErrorArgument> errorArguments = DefaultSdkAutoConstructList.getInstance();
        private List<ValidationExceptionField> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
            this.reason(model.reason);
            this.errorId(model.errorId);
            this.errorArguments(model.errorArguments);
            this.fields(model.fields);
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        @Transient
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        @Transient
        public final Builder reason(ValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getErrorId() {
            return this.errorId;
        }

        public final void setErrorId(String errorId) {
            this.errorId = errorId;
        }

        @Override
        @Transient
        public final Builder errorId(String errorId) {
            this.errorId = errorId;
            return this;
        }

        public final List<ValidationExceptionErrorArgument.Builder> getErrorArguments() {
            List<ValidationExceptionErrorArgument.Builder> result = ValidationExceptionErrorArgumentListCopier.copyToBuilder(this.errorArguments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorArguments(Collection<ValidationExceptionErrorArgument.BuilderImpl> errorArguments) {
            this.errorArguments = ValidationExceptionErrorArgumentListCopier.copyFromBuilder(errorArguments);
        }

        @Override
        @Transient
        public final Builder errorArguments(Collection<ValidationExceptionErrorArgument> errorArguments) {
            this.errorArguments = ValidationExceptionErrorArgumentListCopier.copy(errorArguments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errorArguments(ValidationExceptionErrorArgument ... errorArguments) {
            this.errorArguments(Arrays.asList(errorArguments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errorArguments(Consumer<ValidationExceptionErrorArgument.Builder> ... errorArguments) {
            this.errorArguments(Stream.of(errorArguments).map(c -> (ValidationExceptionErrorArgument)((ValidationExceptionErrorArgument.Builder)ValidationExceptionErrorArgument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ValidationExceptionField.Builder> getFields() {
            List<ValidationExceptionField.Builder> result = ValidationExceptionFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<ValidationExceptionField.BuilderImpl> fields) {
            this.fields = ValidationExceptionFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        @Transient
        public final Builder fields(Collection<ValidationExceptionField> fields) {
            this.fields = ValidationExceptionFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fields(ValidationExceptionField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fields(Consumer<ValidationExceptionField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (ValidationExceptionField)((ValidationExceptionField.Builder)ValidationExceptionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationException>,
    PanoramaException.Builder {
        public Builder reason(String var1);

        public Builder reason(ValidationExceptionReason var1);

        public Builder errorId(String var1);

        public Builder errorArguments(Collection<ValidationExceptionErrorArgument> var1);

        public Builder errorArguments(ValidationExceptionErrorArgument ... var1);

        public Builder errorArguments(Consumer<ValidationExceptionErrorArgument.Builder> ... var1);

        public Builder fields(Collection<ValidationExceptionField> var1);

        public Builder fields(ValidationExceptionField ... var1);

        public Builder fields(Consumer<ValidationExceptionField.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

