/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.DeviceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Device
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Device> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(Device.getter(Device::deviceId)).setter(Device.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Device.getter(Device::name)).setter(Device.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Device.getter(Device::createdTime)).setter(Device.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningStatus").getter(Device.getter(Device::provisioningStatusAsString)).setter(Device.setter(Builder::provisioningStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(Device.getter(Device::lastUpdatedTime)).setter(Device.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<Instant> LEASE_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LeaseExpirationTime").getter(Device.getter(Device::leaseExpirationTime)).setter(Device.setter(Builder::leaseExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseExpirationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, NAME_FIELD, CREATED_TIME_FIELD, PROVISIONING_STATUS_FIELD, LAST_UPDATED_TIME_FIELD, LEASE_EXPIRATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceId;
    private final String name;
    private final Instant createdTime;
    private final String provisioningStatus;
    private final Instant lastUpdatedTime;
    private final Instant leaseExpirationTime;

    private Device(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.name = builder.name;
        this.createdTime = builder.createdTime;
        this.provisioningStatus = builder.provisioningStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.leaseExpirationTime = builder.leaseExpirationTime;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final DeviceStatus provisioningStatus() {
        return DeviceStatus.fromValue(this.provisioningStatus);
    }

    public final String provisioningStatusAsString() {
        return this.provisioningStatus;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final Instant leaseExpirationTime() {
        return this.leaseExpirationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.leaseExpirationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device)obj;
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.provisioningStatusAsString(), other.provisioningStatusAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.leaseExpirationTime(), other.leaseExpirationTime());
    }

    public final String toString() {
        return ToString.builder((String)"Device").add("DeviceId", (Object)this.deviceId()).add("Name", (Object)this.name()).add("CreatedTime", (Object)this.createdTime()).add("ProvisioningStatus", (Object)this.provisioningStatusAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("LeaseExpirationTime", (Object)this.leaseExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "ProvisioningStatus": {
                return Optional.ofNullable(clazz.cast(this.provisioningStatusAsString()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "LeaseExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.leaseExpirationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceId;
        private String name;
        private Instant createdTime;
        private String provisioningStatus;
        private Instant lastUpdatedTime;
        private Instant leaseExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            this.deviceId(model.deviceId);
            this.name(model.name);
            this.createdTime(model.createdTime);
            this.provisioningStatus(model.provisioningStatus);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.leaseExpirationTime(model.leaseExpirationTime);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getProvisioningStatus() {
            return this.provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        @Transient
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder provisioningStatus(DeviceStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getLeaseExpirationTime() {
            return this.leaseExpirationTime;
        }

        public final void setLeaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
        }

        @Override
        @Transient
        public final Builder leaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
            return this;
        }

        public Device build() {
            return new Device(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Device> {
        public Builder deviceId(String var1);

        public Builder name(String var1);

        public Builder createdTime(Instant var1);

        public Builder provisioningStatus(String var1);

        public Builder provisioningStatus(DeviceStatus var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder leaseExpirationTime(Instant var1);
    }
}

