/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.NodeCategory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Node
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Node> {
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(Node.getter(Node::nodeId)).setter(Node.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Node.getter(Node::name)).setter(Node.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(Node.getter(Node::categoryAsString)).setter(Node.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccount").getter(Node.getter(Node::ownerAccount)).setter(Node.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(Node.getter(Node::packageName)).setter(Node.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageId").getter(Node.getter(Node::packageId)).setter(Node.setter(Builder::packageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageId").build()}).build();
    private static final SdkField<String> PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageArn").getter(Node.getter(Node::packageArn)).setter(Node.setter(Builder::packageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageArn").build()}).build();
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageVersion").getter(Node.getter(Node::packageVersion)).setter(Node.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()}).build();
    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatchVersion").getter(Node.getter(Node::patchVersion)).setter(Node.setter(Builder::patchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Node.getter(Node::description)).setter(Node.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Node.getter(Node::createdTime)).setter(Node.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ID_FIELD, NAME_FIELD, CATEGORY_FIELD, OWNER_ACCOUNT_FIELD, PACKAGE_NAME_FIELD, PACKAGE_ID_FIELD, PACKAGE_ARN_FIELD, PACKAGE_VERSION_FIELD, PATCH_VERSION_FIELD, DESCRIPTION_FIELD, CREATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final String name;
    private final String category;
    private final String ownerAccount;
    private final String packageName;
    private final String packageId;
    private final String packageArn;
    private final String packageVersion;
    private final String patchVersion;
    private final String description;
    private final Instant createdTime;

    private Node(BuilderImpl builder) {
        this.nodeId = builder.nodeId;
        this.name = builder.name;
        this.category = builder.category;
        this.ownerAccount = builder.ownerAccount;
        this.packageName = builder.packageName;
        this.packageId = builder.packageId;
        this.packageArn = builder.packageArn;
        this.packageVersion = builder.packageVersion;
        this.patchVersion = builder.patchVersion;
        this.description = builder.description;
        this.createdTime = builder.createdTime;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String name() {
        return this.name;
    }

    public final NodeCategory category() {
        return NodeCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String packageId() {
        return this.packageId;
    }

    public final String packageArn() {
        return this.packageArn;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final String patchVersion() {
        return this.patchVersion;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageId(), other.packageId()) && Objects.equals(this.packageArn(), other.packageArn()) && Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.patchVersion(), other.patchVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public final String toString() {
        return ToString.builder((String)"Node").add("NodeId", (Object)this.nodeId()).add("Name", (Object)this.name()).add("Category", (Object)this.categoryAsString()).add("OwnerAccount", (Object)this.ownerAccount()).add("PackageName", (Object)this.packageName()).add("PackageId", (Object)this.packageId()).add("PackageArn", (Object)this.packageArn()).add("PackageVersion", (Object)this.packageVersion()).add("PatchVersion", (Object)this.patchVersion()).add("Description", (Object)this.description()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "OwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageId": {
                return Optional.ofNullable(clazz.cast(this.packageId()));
            }
            case "PackageArn": {
                return Optional.ofNullable(clazz.cast(this.packageArn()));
            }
            case "PackageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "PatchVersion": {
                return Optional.ofNullable(clazz.cast(this.patchVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeId;
        private String name;
        private String category;
        private String ownerAccount;
        private String packageName;
        private String packageId;
        private String packageArn;
        private String packageVersion;
        private String patchVersion;
        private String description;
        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            this.nodeId(model.nodeId);
            this.name(model.name);
            this.category(model.category);
            this.ownerAccount(model.ownerAccount);
            this.packageName(model.packageName);
            this.packageId(model.packageId);
            this.packageArn(model.packageArn);
            this.packageVersion(model.packageVersion);
            this.patchVersion(model.patchVersion);
            this.description(model.description);
            this.createdTime(model.createdTime);
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        @Transient
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        @Transient
        public final Builder category(NodeCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        @Transient
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        @Transient
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageId() {
            return this.packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        @Transient
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public final String getPackageArn() {
            return this.packageArn;
        }

        public final void setPackageArn(String packageArn) {
            this.packageArn = packageArn;
        }

        @Override
        @Transient
        public final Builder packageArn(String packageArn) {
            this.packageArn = packageArn;
            return this;
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        @Transient
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPatchVersion() {
            return this.patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        @Transient
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Node build() {
            return new Node(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Node> {
        public Builder nodeId(String var1);

        public Builder name(String var1);

        public Builder category(String var1);

        public Builder category(NodeCategory var1);

        public Builder ownerAccount(String var1);

        public Builder packageName(String var1);

        public Builder packageId(String var1);

        public Builder packageArn(String var1);

        public Builder packageVersion(String var1);

        public Builder patchVersion(String var1);

        public Builder description(String var1);

        public Builder createdTime(Instant var1);
    }
}

