/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.services.outposts.model.Subscription;
import software.amazon.awssdk.services.outposts.model.SubscriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOutpostBillingInformationResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, GetOutpostBillingInformationResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetOutpostBillingInformationResponse.getter(GetOutpostBillingInformationResponse::nextToken)).setter(GetOutpostBillingInformationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscriptions").getter(GetOutpostBillingInformationResponse.getter(GetOutpostBillingInformationResponse::subscriptions)).setter(GetOutpostBillingInformationResponse.setter(Builder::subscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTRACT_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContractEndDate").getter(GetOutpostBillingInformationResponse.getter(GetOutpostBillingInformationResponse::contractEndDate)).setter(GetOutpostBillingInformationResponse.setter(Builder::contractEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContractEndDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SUBSCRIPTIONS_FIELD, CONTRACT_END_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOutpostBillingInformationResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<Subscription> subscriptions;
    private final String contractEndDate;

    private GetOutpostBillingInformationResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.subscriptions = builder.subscriptions;
        this.contractEndDate = builder.contractEndDate;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSubscriptions() {
        return this.subscriptions != null && !(this.subscriptions instanceof SdkAutoConstructList);
    }

    public final List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    public final String contractEndDate() {
        return this.contractEndDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptions() ? this.subscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contractEndDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutpostBillingInformationResponse)) {
            return false;
        }
        GetOutpostBillingInformationResponse other = (GetOutpostBillingInformationResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSubscriptions() == other.hasSubscriptions() && Objects.equals(this.subscriptions(), other.subscriptions()) && Objects.equals(this.contractEndDate(), other.contractEndDate());
    }

    public final String toString() {
        return ToString.builder((String)"GetOutpostBillingInformationResponse").add("NextToken", (Object)this.nextToken()).add("Subscriptions", this.hasSubscriptions() ? this.subscriptions() : null).add("ContractEndDate", (Object)this.contractEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Subscriptions": {
                return Optional.ofNullable(clazz.cast(this.subscriptions()));
            }
            case "ContractEndDate": {
                return Optional.ofNullable(clazz.cast(this.contractEndDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Subscriptions", SUBSCRIPTIONS_FIELD);
        map.put("ContractEndDate", CONTRACT_END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOutpostBillingInformationResponse, T> g) {
        return obj -> g.apply((GetOutpostBillingInformationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();
        private String contractEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutpostBillingInformationResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.subscriptions(model.subscriptions);
            this.contractEndDate(model.contractEndDate);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Subscription.Builder> getSubscriptions() {
            List<Subscription.Builder> result = SubscriptionListCopier.copyToBuilder(this.subscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copyFromBuilder(subscriptions);
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Consumer<Subscription.Builder> ... subscriptions) {
            this.subscriptions(Stream.of(subscriptions).map(c -> (Subscription)((Subscription.Builder)Subscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContractEndDate() {
            return this.contractEndDate;
        }

        public final void setContractEndDate(String contractEndDate) {
            this.contractEndDate = contractEndDate;
        }

        @Override
        public final Builder contractEndDate(String contractEndDate) {
            this.contractEndDate = contractEndDate;
            return this;
        }

        @Override
        public GetOutpostBillingInformationResponse build() {
            return new GetOutpostBillingInformationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOutpostBillingInformationResponse> {
        public Builder nextToken(String var1);

        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);

        public Builder subscriptions(Consumer<Subscription.Builder> ... var1);

        public Builder contractEndDate(String var1);
    }
}

