/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.CapacityTaskSummary;
import software.amazon.awssdk.services.outposts.model.ListCapacityTasksRequest;
import software.amazon.awssdk.services.outposts.model.ListCapacityTasksResponse;

public class ListCapacityTasksPublisher
implements SdkPublisher<ListCapacityTasksResponse> {
    private final OutpostsAsyncClient client;
    private final ListCapacityTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCapacityTasksPublisher(OutpostsAsyncClient client, ListCapacityTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCapacityTasksPublisher(OutpostsAsyncClient client, ListCapacityTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCapacityTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCapacityTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityTaskSummary> capacityTasks() {
        Function<ListCapacityTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityTasks() != null) {
                return response.capacityTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCapacityTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCapacityTasksResponseFetcher
    implements AsyncPageFetcher<ListCapacityTasksResponse> {
        private ListCapacityTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListCapacityTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCapacityTasksResponse> nextPage(ListCapacityTasksResponse previousPage) {
            if (previousPage == null) {
                return ListCapacityTasksPublisher.this.client.listCapacityTasks(ListCapacityTasksPublisher.this.firstRequest);
            }
            return ListCapacityTasksPublisher.this.client.listCapacityTasks((ListCapacityTasksRequest)((Object)ListCapacityTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

