/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssetState {
    ACTIVE("ACTIVE"),
    RETIRING("RETIRING"),
    ISOLATED("ISOLATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssetState> VALUE_MAP;
    private final String value;

    private AssetState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssetState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssetState> knownValues() {
        EnumSet<AssetState> knownValues = EnumSet.allOf(AssetState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssetState.class, AssetState::toString);
    }
}

