/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OrderStatus {
    RECEIVED("RECEIVED"),
    PENDING("PENDING"),
    PROCESSING("PROCESSING"),
    INSTALLING("INSTALLING"),
    FULFILLED("FULFILLED"),
    CANCELLED("CANCELLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OrderStatus> VALUE_MAP;
    private final String value;

    private OrderStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OrderStatus> knownValues() {
        EnumSet<OrderStatus> knownValues = EnumSet.allOf(OrderStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OrderStatus.class, OrderStatus::toString);
    }
}

