/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.CatalogItem;
import software.amazon.awssdk.services.outposts.model.CatalogItemListDefinitionCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCatalogItemsResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, ListCatalogItemsResponse> {
    private static final SdkField<List<CatalogItem>> CATALOG_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CatalogItems").getter(ListCatalogItemsResponse.getter(ListCatalogItemsResponse::catalogItems)).setter(ListCatalogItemsResponse.setter(Builder::catalogItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CatalogItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCatalogItemsResponse.getter(ListCatalogItemsResponse::nextToken)).setter(ListCatalogItemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CatalogItem> catalogItems;
    private final String nextToken;

    private ListCatalogItemsResponse(BuilderImpl builder) {
        super(builder);
        this.catalogItems = builder.catalogItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCatalogItems() {
        return this.catalogItems != null && !(this.catalogItems instanceof SdkAutoConstructList);
    }

    public final List<CatalogItem> catalogItems() {
        return this.catalogItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCatalogItems() ? this.catalogItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCatalogItemsResponse)) {
            return false;
        }
        ListCatalogItemsResponse other = (ListCatalogItemsResponse)((Object)obj);
        return this.hasCatalogItems() == other.hasCatalogItems() && Objects.equals(this.catalogItems(), other.catalogItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCatalogItemsResponse").add("CatalogItems", this.hasCatalogItems() ? this.catalogItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogItems": {
                return Optional.ofNullable(clazz.cast(this.catalogItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCatalogItemsResponse, T> g) {
        return obj -> g.apply((ListCatalogItemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private List<CatalogItem> catalogItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCatalogItemsResponse model) {
            super(model);
            this.catalogItems(model.catalogItems);
            this.nextToken(model.nextToken);
        }

        public final List<CatalogItem.Builder> getCatalogItems() {
            List<CatalogItem.Builder> result = CatalogItemListDefinitionCopier.copyToBuilder(this.catalogItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCatalogItems(Collection<CatalogItem.BuilderImpl> catalogItems) {
            this.catalogItems = CatalogItemListDefinitionCopier.copyFromBuilder(catalogItems);
        }

        @Override
        public final Builder catalogItems(Collection<CatalogItem> catalogItems) {
            this.catalogItems = CatalogItemListDefinitionCopier.copy(catalogItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder catalogItems(CatalogItem ... catalogItems) {
            this.catalogItems(Arrays.asList(catalogItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder catalogItems(Consumer<CatalogItem.Builder> ... catalogItems) {
            this.catalogItems(Stream.of(catalogItems).map(c -> (CatalogItem)((CatalogItem.Builder)CatalogItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCatalogItemsResponse build() {
            return new ListCatalogItemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCatalogItemsResponse> {
        public Builder catalogItems(Collection<CatalogItem> var1);

        public Builder catalogItems(CatalogItem ... var1);

        public Builder catalogItems(Consumer<CatalogItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

