/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.outposts.model.LineItemStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineItem> {
    private static final SdkField<String> CATALOG_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogItemId").getter(LineItem.getter(LineItem::catalogItemId)).setter(LineItem.setter(Builder::catalogItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItemId").build()}).build();
    private static final SdkField<String> LINE_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LineItemId").getter(LineItem.getter(LineItem::lineItemId)).setter(LineItem.setter(Builder::lineItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemId").build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(LineItem.getter(LineItem::quantity)).setter(LineItem.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LineItem.getter(LineItem::statusAsString)).setter(LineItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEM_ID_FIELD, LINE_ITEM_ID_FIELD, QUANTITY_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String catalogItemId;
    private final String lineItemId;
    private final Integer quantity;
    private final String status;

    private LineItem(BuilderImpl builder) {
        this.catalogItemId = builder.catalogItemId;
        this.lineItemId = builder.lineItemId;
        this.quantity = builder.quantity;
        this.status = builder.status;
    }

    public final String catalogItemId() {
        return this.catalogItemId;
    }

    public final String lineItemId() {
        return this.lineItemId;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public final LineItemStatus status() {
        return LineItemStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItem)) {
            return false;
        }
        LineItem other = (LineItem)obj;
        return Objects.equals(this.catalogItemId(), other.catalogItemId()) && Objects.equals(this.lineItemId(), other.lineItemId()) && Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LineItem").add("CatalogItemId", (Object)this.catalogItemId()).add("LineItemId", (Object)this.lineItemId()).add("Quantity", (Object)this.quantity()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogItemId": {
                return Optional.ofNullable(clazz.cast(this.catalogItemId()));
            }
            case "LineItemId": {
                return Optional.ofNullable(clazz.cast(this.lineItemId()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineItem, T> g) {
        return obj -> g.apply((LineItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogItemId;
        private String lineItemId;
        private Integer quantity;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LineItem model) {
            this.catalogItemId(model.catalogItemId);
            this.lineItemId(model.lineItemId);
            this.quantity(model.quantity);
            this.status(model.status);
        }

        public final String getCatalogItemId() {
            return this.catalogItemId;
        }

        public final void setCatalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
        }

        @Override
        public final Builder catalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
            return this;
        }

        public final String getLineItemId() {
            return this.lineItemId;
        }

        public final void setLineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
        }

        @Override
        public final Builder lineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
            return this;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LineItemStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public LineItem build() {
            return new LineItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineItem> {
        public Builder catalogItemId(String var1);

        public Builder lineItemId(String var1);

        public Builder quantity(Integer var1);

        public Builder status(String var1);

        public Builder status(LineItemStatus var1);
    }
}

