/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.osis.OsisClient;
import software.amazon.awssdk.services.osis.internal.UserAgentUtils;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsResponse;
import software.amazon.awssdk.services.osis.model.PipelineEndpointConnection;

public class ListPipelineEndpointConnectionsIterable
implements SdkIterable<ListPipelineEndpointConnectionsResponse> {
    private final OsisClient client;
    private final ListPipelineEndpointConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPipelineEndpointConnectionsIterable(OsisClient client, ListPipelineEndpointConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPipelineEndpointConnectionsResponseFetcher();
    }

    public Iterator<ListPipelineEndpointConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PipelineEndpointConnection> pipelineEndpointConnections() {
        Function<ListPipelineEndpointConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineEndpointConnections() != null) {
                return response.pipelineEndpointConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPipelineEndpointConnectionsResponseFetcher
    implements SyncPageFetcher<ListPipelineEndpointConnectionsResponse> {
        private ListPipelineEndpointConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineEndpointConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPipelineEndpointConnectionsResponse nextPage(ListPipelineEndpointConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineEndpointConnectionsIterable.this.client.listPipelineEndpointConnections(ListPipelineEndpointConnectionsIterable.this.firstRequest);
            }
            return ListPipelineEndpointConnectionsIterable.this.client.listPipelineEndpointConnections((ListPipelineEndpointConnectionsRequest)((Object)ListPipelineEndpointConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

