/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.osis.model.OsisResponse;
import software.amazon.awssdk.services.osis.model.PipelineEndpointConnection;
import software.amazon.awssdk.services.osis.model.PipelineEndpointConnectionsSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPipelineEndpointConnectionsResponse
extends OsisResponse
implements ToCopyableBuilder<Builder, ListPipelineEndpointConnectionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPipelineEndpointConnectionsResponse.getter(ListPipelineEndpointConnectionsResponse::nextToken)).setter(ListPipelineEndpointConnectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<PipelineEndpointConnection>> PIPELINE_ENDPOINT_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PipelineEndpointConnections").getter(ListPipelineEndpointConnectionsResponse.getter(ListPipelineEndpointConnectionsResponse::pipelineEndpointConnections)).setter(ListPipelineEndpointConnectionsResponse.setter(Builder::pipelineEndpointConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineEndpointConnections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineEndpointConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PIPELINE_ENDPOINT_CONNECTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPipelineEndpointConnectionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<PipelineEndpointConnection> pipelineEndpointConnections;

    private ListPipelineEndpointConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pipelineEndpointConnections = builder.pipelineEndpointConnections;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPipelineEndpointConnections() {
        return this.pipelineEndpointConnections != null && !(this.pipelineEndpointConnections instanceof SdkAutoConstructList);
    }

    public final List<PipelineEndpointConnection> pipelineEndpointConnections() {
        return this.pipelineEndpointConnections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineEndpointConnections() ? this.pipelineEndpointConnections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineEndpointConnectionsResponse)) {
            return false;
        }
        ListPipelineEndpointConnectionsResponse other = (ListPipelineEndpointConnectionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPipelineEndpointConnections() == other.hasPipelineEndpointConnections() && Objects.equals(this.pipelineEndpointConnections(), other.pipelineEndpointConnections());
    }

    public final String toString() {
        return ToString.builder((String)"ListPipelineEndpointConnectionsResponse").add("NextToken", (Object)this.nextToken()).add("PipelineEndpointConnections", this.hasPipelineEndpointConnections() ? this.pipelineEndpointConnections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PipelineEndpointConnections": {
                return Optional.ofNullable(clazz.cast(this.pipelineEndpointConnections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PipelineEndpointConnections", PIPELINE_ENDPOINT_CONNECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineEndpointConnectionsResponse, T> g) {
        return obj -> g.apply((ListPipelineEndpointConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OsisResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PipelineEndpointConnection> pipelineEndpointConnections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineEndpointConnectionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.pipelineEndpointConnections(model.pipelineEndpointConnections);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PipelineEndpointConnection.Builder> getPipelineEndpointConnections() {
            List<PipelineEndpointConnection.Builder> result = PipelineEndpointConnectionsSummaryListCopier.copyToBuilder(this.pipelineEndpointConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineEndpointConnections(Collection<PipelineEndpointConnection.BuilderImpl> pipelineEndpointConnections) {
            this.pipelineEndpointConnections = PipelineEndpointConnectionsSummaryListCopier.copyFromBuilder(pipelineEndpointConnections);
        }

        @Override
        public final Builder pipelineEndpointConnections(Collection<PipelineEndpointConnection> pipelineEndpointConnections) {
            this.pipelineEndpointConnections = PipelineEndpointConnectionsSummaryListCopier.copy(pipelineEndpointConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineEndpointConnections(PipelineEndpointConnection ... pipelineEndpointConnections) {
            this.pipelineEndpointConnections(Arrays.asList(pipelineEndpointConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineEndpointConnections(Consumer<PipelineEndpointConnection.Builder> ... pipelineEndpointConnections) {
            this.pipelineEndpointConnections(Stream.of(pipelineEndpointConnections).map(c -> (PipelineEndpointConnection)((PipelineEndpointConnection.Builder)PipelineEndpointConnection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPipelineEndpointConnectionsResponse build() {
            return new ListPipelineEndpointConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OsisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPipelineEndpointConnectionsResponse> {
        public Builder nextToken(String var1);

        public Builder pipelineEndpointConnections(Collection<PipelineEndpointConnection> var1);

        public Builder pipelineEndpointConnections(PipelineEndpointConnection ... var1);

        public Builder pipelineEndpointConnections(Consumer<PipelineEndpointConnection.Builder> ... var1);
    }
}

