/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcOptions implements SdkPojo, Serializable, ToCopyableBuilder<VpcOptions.Builder, VpcOptions> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(VpcOptions::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(VpcOptions::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VpcAttachmentOptions> VPC_ATTACHMENT_OPTIONS_FIELD = SdkField
            .<VpcAttachmentOptions> builder(MarshallingType.SDK_POJO).memberName("VpcAttachmentOptions")
            .getter(getter(VpcOptions::vpcAttachmentOptions)).setter(setter(Builder::vpcAttachmentOptions))
            .constructor(VpcAttachmentOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcAttachmentOptions").build())
            .build();

    private static final SdkField<String> VPC_ENDPOINT_MANAGEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointManagement").getter(getter(VpcOptions::vpcEndpointManagementAsString))
            .setter(setter(Builder::vpcEndpointManagement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointManagement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD,
            SECURITY_GROUP_IDS_FIELD, VPC_ATTACHMENT_OPTIONS_FIELD, VPC_ENDPOINT_MANAGEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final VpcAttachmentOptions vpcAttachmentOptions;

    private final String vpcEndpointManagement;

    private VpcOptions(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.vpcAttachmentOptions = builder.vpcAttachmentOptions;
        this.vpcEndpointManagement = builder.vpcEndpointManagement;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subnet IDs associated with the VPC endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return A list of subnet IDs associated with the VPC endpoint.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security groups associated with the VPC endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of security groups associated with the VPC endpoint.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Options for attaching a VPC to a pipeline.
     * </p>
     * 
     * @return Options for attaching a VPC to a pipeline.
     */
    public final VpcAttachmentOptions vpcAttachmentOptions() {
        return vpcAttachmentOptions;
    }

    /**
     * <p>
     * Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint configured for the
     * pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vpcEndpointManagement} will return {@link VpcEndpointManagement#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vpcEndpointManagementAsString}.
     * </p>
     * 
     * @return Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint configured
     *         for the pipeline.
     * @see VpcEndpointManagement
     */
    public final VpcEndpointManagement vpcEndpointManagement() {
        return VpcEndpointManagement.fromValue(vpcEndpointManagement);
    }

    /**
     * <p>
     * Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint configured for the
     * pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vpcEndpointManagement} will return {@link VpcEndpointManagement#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vpcEndpointManagementAsString}.
     * </p>
     * 
     * @return Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint configured
     *         for the pipeline.
     * @see VpcEndpointManagement
     */
    public final String vpcEndpointManagementAsString() {
        return vpcEndpointManagement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcAttachmentOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointManagementAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOptions)) {
            return false;
        }
        VpcOptions other = (VpcOptions) obj;
        return hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(vpcAttachmentOptions(), other.vpcAttachmentOptions())
                && Objects.equals(vpcEndpointManagementAsString(), other.vpcEndpointManagementAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcOptions").add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("VpcAttachmentOptions", vpcAttachmentOptions())
                .add("VpcEndpointManagement", vpcEndpointManagementAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "VpcAttachmentOptions":
            return Optional.ofNullable(clazz.cast(vpcAttachmentOptions()));
        case "VpcEndpointManagement":
            return Optional.ofNullable(clazz.cast(vpcEndpointManagementAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("VpcAttachmentOptions", VPC_ATTACHMENT_OPTIONS_FIELD);
        map.put("VpcEndpointManagement", VPC_ENDPOINT_MANAGEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcOptions, T> g) {
        return obj -> g.apply((VpcOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcOptions> {
        /**
         * <p>
         * A list of subnet IDs associated with the VPC endpoint.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs associated with the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of subnet IDs associated with the VPC endpoint.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs associated with the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of security groups associated with the VPC endpoint.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security groups associated with the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of security groups associated with the VPC endpoint.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security groups associated with the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Options for attaching a VPC to a pipeline.
         * </p>
         * 
         * @param vpcAttachmentOptions
         *        Options for attaching a VPC to a pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcAttachmentOptions(VpcAttachmentOptions vpcAttachmentOptions);

        /**
         * <p>
         * Options for attaching a VPC to a pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcAttachmentOptions.Builder} avoiding
         * the need to create one manually via {@link VpcAttachmentOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcAttachmentOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcAttachmentOptions(VpcAttachmentOptions)}.
         * 
         * @param vpcAttachmentOptions
         *        a consumer that will call methods on {@link VpcAttachmentOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcAttachmentOptions(VpcAttachmentOptions)
         */
        default Builder vpcAttachmentOptions(Consumer<VpcAttachmentOptions.Builder> vpcAttachmentOptions) {
            return vpcAttachmentOptions(VpcAttachmentOptions.builder().applyMutation(vpcAttachmentOptions).build());
        }

        /**
         * <p>
         * Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint configured for
         * the pipeline.
         * </p>
         * 
         * @param vpcEndpointManagement
         *        Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint
         *        configured for the pipeline.
         * @see VpcEndpointManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointManagement
         */
        Builder vpcEndpointManagement(String vpcEndpointManagement);

        /**
         * <p>
         * Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint configured for
         * the pipeline.
         * </p>
         * 
         * @param vpcEndpointManagement
         *        Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint
         *        configured for the pipeline.
         * @see VpcEndpointManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointManagement
         */
        Builder vpcEndpointManagement(VpcEndpointManagement vpcEndpointManagement);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private VpcAttachmentOptions vpcAttachmentOptions;

        private String vpcEndpointManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOptions model) {
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            vpcAttachmentOptions(model.vpcAttachmentOptions);
            vpcEndpointManagement(model.vpcEndpointManagement);
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final VpcAttachmentOptions.Builder getVpcAttachmentOptions() {
            return vpcAttachmentOptions != null ? vpcAttachmentOptions.toBuilder() : null;
        }

        public final void setVpcAttachmentOptions(VpcAttachmentOptions.BuilderImpl vpcAttachmentOptions) {
            this.vpcAttachmentOptions = vpcAttachmentOptions != null ? vpcAttachmentOptions.build() : null;
        }

        @Override
        public final Builder vpcAttachmentOptions(VpcAttachmentOptions vpcAttachmentOptions) {
            this.vpcAttachmentOptions = vpcAttachmentOptions;
            return this;
        }

        public final String getVpcEndpointManagement() {
            return vpcEndpointManagement;
        }

        public final void setVpcEndpointManagement(String vpcEndpointManagement) {
            this.vpcEndpointManagement = vpcEndpointManagement;
        }

        @Override
        public final Builder vpcEndpointManagement(String vpcEndpointManagement) {
            this.vpcEndpointManagement = vpcEndpointManagement;
            return this;
        }

        @Override
        public final Builder vpcEndpointManagement(VpcEndpointManagement vpcEndpointManagement) {
            this.vpcEndpointManagement(vpcEndpointManagement == null ? null : vpcEndpointManagement.toString());
            return this;
        }

        @Override
        public VpcOptions build() {
            return new VpcOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
