/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.osis.model.BufferOptions;
import software.amazon.awssdk.services.osis.model.EncryptionAtRestOptions;
import software.amazon.awssdk.services.osis.model.IngestEndpointUrlsListCopier;
import software.amazon.awssdk.services.osis.model.LogPublishingOptions;
import software.amazon.awssdk.services.osis.model.PipelineDestination;
import software.amazon.awssdk.services.osis.model.PipelineDestinationListCopier;
import software.amazon.awssdk.services.osis.model.PipelineStatus;
import software.amazon.awssdk.services.osis.model.PipelineStatusReason;
import software.amazon.awssdk.services.osis.model.ServiceVpcEndpoint;
import software.amazon.awssdk.services.osis.model.ServiceVpcEndpointsListCopier;
import software.amazon.awssdk.services.osis.model.Tag;
import software.amazon.awssdk.services.osis.model.TagListCopier;
import software.amazon.awssdk.services.osis.model.VpcEndpoint;
import software.amazon.awssdk.services.osis.model.VpcEndpointsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Pipeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Pipeline> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineName").getter(Pipeline.getter(Pipeline::pipelineName)).setter(Pipeline.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()}).build();
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineArn").getter(Pipeline.getter(Pipeline::pipelineArn)).setter(Pipeline.setter(Builder::pipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()}).build();
    private static final SdkField<Integer> MIN_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinUnits").getter(Pipeline.getter(Pipeline::minUnits)).setter(Pipeline.setter(Builder::minUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinUnits").build()}).build();
    private static final SdkField<Integer> MAX_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxUnits").getter(Pipeline.getter(Pipeline::maxUnits)).setter(Pipeline.setter(Builder::maxUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUnits").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Pipeline.getter(Pipeline::statusAsString)).setter(Pipeline.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<PipelineStatusReason> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatusReason").getter(Pipeline.getter(Pipeline::statusReason)).setter(Pipeline.setter(Builder::statusReason)).constructor(PipelineStatusReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> PIPELINE_CONFIGURATION_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineConfigurationBody").getter(Pipeline.getter(Pipeline::pipelineConfigurationBody)).setter(Pipeline.setter(Builder::pipelineConfigurationBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineConfigurationBody").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Pipeline.getter(Pipeline::createdAt)).setter(Pipeline.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(Pipeline.getter(Pipeline::lastUpdatedAt)).setter(Pipeline.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<List<String>> INGEST_ENDPOINT_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IngestEndpointUrls").getter(Pipeline.getter(Pipeline::ingestEndpointUrls)).setter(Pipeline.setter(Builder::ingestEndpointUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestEndpointUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LogPublishingOptions> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingOptions").getter(Pipeline.getter(Pipeline::logPublishingOptions)).setter(Pipeline.setter(Builder::logPublishingOptions)).constructor(LogPublishingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build()}).build();
    private static final SdkField<List<VpcEndpoint>> VPC_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcEndpoints").getter(Pipeline.getter(Pipeline::vpcEndpoints)).setter(Pipeline.setter(Builder::vpcEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BufferOptions> BUFFER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferOptions").getter(Pipeline.getter(Pipeline::bufferOptions)).setter(Pipeline.setter(Builder::bufferOptions)).constructor(BufferOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferOptions").build()}).build();
    private static final SdkField<EncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions").getter(Pipeline.getter(Pipeline::encryptionAtRestOptions)).setter(Pipeline.setter(Builder::encryptionAtRestOptions)).constructor(EncryptionAtRestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointService").getter(Pipeline.getter(Pipeline::vpcEndpointService)).setter(Pipeline.setter(Builder::vpcEndpointService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointService").build()}).build();
    private static final SdkField<List<ServiceVpcEndpoint>> SERVICE_VPC_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceVpcEndpoints").getter(Pipeline.getter(Pipeline::serviceVpcEndpoints)).setter(Pipeline.setter(Builder::serviceVpcEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceVpcEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceVpcEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PipelineDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(Pipeline.getter(Pipeline::destinations)).setter(Pipeline.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Pipeline.getter(Pipeline::tags)).setter(Pipeline.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_ARN_FIELD, MIN_UNITS_FIELD, MAX_UNITS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, PIPELINE_CONFIGURATION_BODY_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, INGEST_ENDPOINT_URLS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, VPC_ENDPOINTS_FIELD, BUFFER_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, VPC_ENDPOINT_SERVICE_FIELD, SERVICE_VPC_ENDPOINTS_FIELD, DESTINATIONS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pipelineName;
    private final String pipelineArn;
    private final Integer minUnits;
    private final Integer maxUnits;
    private final String status;
    private final PipelineStatusReason statusReason;
    private final String pipelineConfigurationBody;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final List<String> ingestEndpointUrls;
    private final LogPublishingOptions logPublishingOptions;
    private final List<VpcEndpoint> vpcEndpoints;
    private final BufferOptions bufferOptions;
    private final EncryptionAtRestOptions encryptionAtRestOptions;
    private final String vpcEndpointService;
    private final List<ServiceVpcEndpoint> serviceVpcEndpoints;
    private final List<PipelineDestination> destinations;
    private final List<Tag> tags;

    private Pipeline(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.pipelineArn = builder.pipelineArn;
        this.minUnits = builder.minUnits;
        this.maxUnits = builder.maxUnits;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.pipelineConfigurationBody = builder.pipelineConfigurationBody;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.ingestEndpointUrls = builder.ingestEndpointUrls;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.vpcEndpoints = builder.vpcEndpoints;
        this.bufferOptions = builder.bufferOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.vpcEndpointService = builder.vpcEndpointService;
        this.serviceVpcEndpoints = builder.serviceVpcEndpoints;
        this.destinations = builder.destinations;
        this.tags = builder.tags;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final String pipelineArn() {
        return this.pipelineArn;
    }

    public final Integer minUnits() {
        return this.minUnits;
    }

    public final Integer maxUnits() {
        return this.maxUnits;
    }

    public final PipelineStatus status() {
        return PipelineStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final PipelineStatusReason statusReason() {
        return this.statusReason;
    }

    public final String pipelineConfigurationBody() {
        return this.pipelineConfigurationBody;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasIngestEndpointUrls() {
        return this.ingestEndpointUrls != null && !(this.ingestEndpointUrls instanceof SdkAutoConstructList);
    }

    public final List<String> ingestEndpointUrls() {
        return this.ingestEndpointUrls;
    }

    public final LogPublishingOptions logPublishingOptions() {
        return this.logPublishingOptions;
    }

    public final boolean hasVpcEndpoints() {
        return this.vpcEndpoints != null && !(this.vpcEndpoints instanceof SdkAutoConstructList);
    }

    public final List<VpcEndpoint> vpcEndpoints() {
        return this.vpcEndpoints;
    }

    public final BufferOptions bufferOptions() {
        return this.bufferOptions;
    }

    public final EncryptionAtRestOptions encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public final String vpcEndpointService() {
        return this.vpcEndpointService;
    }

    public final boolean hasServiceVpcEndpoints() {
        return this.serviceVpcEndpoints != null && !(this.serviceVpcEndpoints instanceof SdkAutoConstructList);
    }

    public final List<ServiceVpcEndpoint> serviceVpcEndpoints() {
        return this.serviceVpcEndpoints;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<PipelineDestination> destinations() {
        return this.destinations;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.minUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineConfigurationBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIngestEndpointUrls() ? this.ingestEndpointUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEndpoints() ? this.vpcEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointService());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceVpcEndpoints() ? this.serviceVpcEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pipeline)) {
            return false;
        }
        Pipeline other = (Pipeline)obj;
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineArn(), other.pipelineArn()) && Objects.equals(this.minUnits(), other.minUnits()) && Objects.equals(this.maxUnits(), other.maxUnits()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.pipelineConfigurationBody(), other.pipelineConfigurationBody()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasIngestEndpointUrls() == other.hasIngestEndpointUrls() && Objects.equals(this.ingestEndpointUrls(), other.ingestEndpointUrls()) && Objects.equals(this.logPublishingOptions(), other.logPublishingOptions()) && this.hasVpcEndpoints() == other.hasVpcEndpoints() && Objects.equals(this.vpcEndpoints(), other.vpcEndpoints()) && Objects.equals(this.bufferOptions(), other.bufferOptions()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.vpcEndpointService(), other.vpcEndpointService()) && this.hasServiceVpcEndpoints() == other.hasServiceVpcEndpoints() && Objects.equals(this.serviceVpcEndpoints(), other.serviceVpcEndpoints()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Pipeline").add("PipelineName", (Object)this.pipelineName()).add("PipelineArn", (Object)this.pipelineArn()).add("MinUnits", (Object)this.minUnits()).add("MaxUnits", (Object)this.maxUnits()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("PipelineConfigurationBody", (Object)this.pipelineConfigurationBody()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("IngestEndpointUrls", this.hasIngestEndpointUrls() ? this.ingestEndpointUrls() : null).add("LogPublishingOptions", (Object)this.logPublishingOptions()).add("VpcEndpoints", this.hasVpcEndpoints() ? this.vpcEndpoints() : null).add("BufferOptions", (Object)this.bufferOptions()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("VpcEndpointService", (Object)this.vpcEndpointService()).add("ServiceVpcEndpoints", this.hasServiceVpcEndpoints() ? this.serviceVpcEndpoints() : null).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "PipelineArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineArn()));
            }
            case "MinUnits": {
                return Optional.ofNullable(clazz.cast(this.minUnits()));
            }
            case "MaxUnits": {
                return Optional.ofNullable(clazz.cast(this.maxUnits()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "PipelineConfigurationBody": {
                return Optional.ofNullable(clazz.cast(this.pipelineConfigurationBody()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "IngestEndpointUrls": {
                return Optional.ofNullable(clazz.cast(this.ingestEndpointUrls()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptions()));
            }
            case "VpcEndpoints": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpoints()));
            }
            case "BufferOptions": {
                return Optional.ofNullable(clazz.cast(this.bufferOptions()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "VpcEndpointService": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointService()));
            }
            case "ServiceVpcEndpoints": {
                return Optional.ofNullable(clazz.cast(this.serviceVpcEndpoints()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Pipeline, T> g) {
        return obj -> g.apply((Pipeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private String pipelineArn;
        private Integer minUnits;
        private Integer maxUnits;
        private String status;
        private PipelineStatusReason statusReason;
        private String pipelineConfigurationBody;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private List<String> ingestEndpointUrls = DefaultSdkAutoConstructList.getInstance();
        private LogPublishingOptions logPublishingOptions;
        private List<VpcEndpoint> vpcEndpoints = DefaultSdkAutoConstructList.getInstance();
        private BufferOptions bufferOptions;
        private EncryptionAtRestOptions encryptionAtRestOptions;
        private String vpcEndpointService;
        private List<ServiceVpcEndpoint> serviceVpcEndpoints = DefaultSdkAutoConstructList.getInstance();
        private List<PipelineDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Pipeline model) {
            this.pipelineName(model.pipelineName);
            this.pipelineArn(model.pipelineArn);
            this.minUnits(model.minUnits);
            this.maxUnits(model.maxUnits);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.pipelineConfigurationBody(model.pipelineConfigurationBody);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.ingestEndpointUrls(model.ingestEndpointUrls);
            this.logPublishingOptions(model.logPublishingOptions);
            this.vpcEndpoints(model.vpcEndpoints);
            this.bufferOptions(model.bufferOptions);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.vpcEndpointService(model.vpcEndpointService);
            this.serviceVpcEndpoints(model.serviceVpcEndpoints);
            this.destinations(model.destinations);
            this.tags(model.tags);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getPipelineArn() {
            return this.pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final Integer getMinUnits() {
            return this.minUnits;
        }

        public final void setMinUnits(Integer minUnits) {
            this.minUnits = minUnits;
        }

        @Override
        public final Builder minUnits(Integer minUnits) {
            this.minUnits = minUnits;
            return this;
        }

        public final Integer getMaxUnits() {
            return this.maxUnits;
        }

        public final void setMaxUnits(Integer maxUnits) {
            this.maxUnits = maxUnits;
        }

        @Override
        public final Builder maxUnits(Integer maxUnits) {
            this.maxUnits = maxUnits;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final PipelineStatusReason.Builder getStatusReason() {
            return this.statusReason != null ? this.statusReason.toBuilder() : null;
        }

        public final void setStatusReason(PipelineStatusReason.BuilderImpl statusReason) {
            this.statusReason = statusReason != null ? statusReason.build() : null;
        }

        @Override
        public final Builder statusReason(PipelineStatusReason statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getPipelineConfigurationBody() {
            return this.pipelineConfigurationBody;
        }

        public final void setPipelineConfigurationBody(String pipelineConfigurationBody) {
            this.pipelineConfigurationBody = pipelineConfigurationBody;
        }

        @Override
        public final Builder pipelineConfigurationBody(String pipelineConfigurationBody) {
            this.pipelineConfigurationBody = pipelineConfigurationBody;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Collection<String> getIngestEndpointUrls() {
            if (this.ingestEndpointUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ingestEndpointUrls;
        }

        public final void setIngestEndpointUrls(Collection<String> ingestEndpointUrls) {
            this.ingestEndpointUrls = IngestEndpointUrlsListCopier.copy(ingestEndpointUrls);
        }

        @Override
        public final Builder ingestEndpointUrls(Collection<String> ingestEndpointUrls) {
            this.ingestEndpointUrls = IngestEndpointUrlsListCopier.copy(ingestEndpointUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestEndpointUrls(String ... ingestEndpointUrls) {
            this.ingestEndpointUrls(Arrays.asList(ingestEndpointUrls));
            return this;
        }

        public final LogPublishingOptions.Builder getLogPublishingOptions() {
            return this.logPublishingOptions != null ? this.logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(LogPublishingOptions.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        public final Builder logPublishingOptions(LogPublishingOptions logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final List<VpcEndpoint.Builder> getVpcEndpoints() {
            List<VpcEndpoint.Builder> result = VpcEndpointsListCopier.copyToBuilder(this.vpcEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpoints(Collection<VpcEndpoint.BuilderImpl> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointsListCopier.copyFromBuilder(vpcEndpoints);
        }

        @Override
        public final Builder vpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointsListCopier.copy(vpcEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(VpcEndpoint ... vpcEndpoints) {
            this.vpcEndpoints(Arrays.asList(vpcEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(Consumer<VpcEndpoint.Builder> ... vpcEndpoints) {
            this.vpcEndpoints(Stream.of(vpcEndpoints).map(c -> (VpcEndpoint)((VpcEndpoint.Builder)VpcEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BufferOptions.Builder getBufferOptions() {
            return this.bufferOptions != null ? this.bufferOptions.toBuilder() : null;
        }

        public final void setBufferOptions(BufferOptions.BuilderImpl bufferOptions) {
            this.bufferOptions = bufferOptions != null ? bufferOptions.build() : null;
        }

        @Override
        public final Builder bufferOptions(BufferOptions bufferOptions) {
            this.bufferOptions = bufferOptions;
            return this;
        }

        public final EncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final String getVpcEndpointService() {
            return this.vpcEndpointService;
        }

        public final void setVpcEndpointService(String vpcEndpointService) {
            this.vpcEndpointService = vpcEndpointService;
        }

        @Override
        public final Builder vpcEndpointService(String vpcEndpointService) {
            this.vpcEndpointService = vpcEndpointService;
            return this;
        }

        public final List<ServiceVpcEndpoint.Builder> getServiceVpcEndpoints() {
            List<ServiceVpcEndpoint.Builder> result = ServiceVpcEndpointsListCopier.copyToBuilder(this.serviceVpcEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceVpcEndpoints(Collection<ServiceVpcEndpoint.BuilderImpl> serviceVpcEndpoints) {
            this.serviceVpcEndpoints = ServiceVpcEndpointsListCopier.copyFromBuilder(serviceVpcEndpoints);
        }

        @Override
        public final Builder serviceVpcEndpoints(Collection<ServiceVpcEndpoint> serviceVpcEndpoints) {
            this.serviceVpcEndpoints = ServiceVpcEndpointsListCopier.copy(serviceVpcEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceVpcEndpoints(ServiceVpcEndpoint ... serviceVpcEndpoints) {
            this.serviceVpcEndpoints(Arrays.asList(serviceVpcEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceVpcEndpoints(Consumer<ServiceVpcEndpoint.Builder> ... serviceVpcEndpoints) {
            this.serviceVpcEndpoints(Stream.of(serviceVpcEndpoints).map(c -> (ServiceVpcEndpoint)((ServiceVpcEndpoint.Builder)ServiceVpcEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PipelineDestination.Builder> getDestinations() {
            List<PipelineDestination.Builder> result = PipelineDestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<PipelineDestination.BuilderImpl> destinations) {
            this.destinations = PipelineDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<PipelineDestination> destinations) {
            this.destinations = PipelineDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(PipelineDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<PipelineDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (PipelineDestination)((PipelineDestination.Builder)PipelineDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Pipeline build() {
            return new Pipeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Pipeline> {
        public Builder pipelineName(String var1);

        public Builder pipelineArn(String var1);

        public Builder minUnits(Integer var1);

        public Builder maxUnits(Integer var1);

        public Builder status(String var1);

        public Builder status(PipelineStatus var1);

        public Builder statusReason(PipelineStatusReason var1);

        default public Builder statusReason(Consumer<PipelineStatusReason.Builder> statusReason) {
            return this.statusReason((PipelineStatusReason)((PipelineStatusReason.Builder)PipelineStatusReason.builder().applyMutation(statusReason)).build());
        }

        public Builder pipelineConfigurationBody(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder ingestEndpointUrls(Collection<String> var1);

        public Builder ingestEndpointUrls(String ... var1);

        public Builder logPublishingOptions(LogPublishingOptions var1);

        default public Builder logPublishingOptions(Consumer<LogPublishingOptions.Builder> logPublishingOptions) {
            return this.logPublishingOptions((LogPublishingOptions)((LogPublishingOptions.Builder)LogPublishingOptions.builder().applyMutation(logPublishingOptions)).build());
        }

        public Builder vpcEndpoints(Collection<VpcEndpoint> var1);

        public Builder vpcEndpoints(VpcEndpoint ... var1);

        public Builder vpcEndpoints(Consumer<VpcEndpoint.Builder> ... var1);

        public Builder bufferOptions(BufferOptions var1);

        default public Builder bufferOptions(Consumer<BufferOptions.Builder> bufferOptions) {
            return this.bufferOptions((BufferOptions)((BufferOptions.Builder)BufferOptions.builder().applyMutation(bufferOptions)).build());
        }

        public Builder encryptionAtRestOptions(EncryptionAtRestOptions var1);

        default public Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((EncryptionAtRestOptions)((EncryptionAtRestOptions.Builder)EncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder vpcEndpointService(String var1);

        public Builder serviceVpcEndpoints(Collection<ServiceVpcEndpoint> var1);

        public Builder serviceVpcEndpoints(ServiceVpcEndpoint ... var1);

        public Builder serviceVpcEndpoints(Consumer<ServiceVpcEndpoint.Builder> ... var1);

        public Builder destinations(Collection<PipelineDestination> var1);

        public Builder destinations(PipelineDestination ... var1);

        public Builder destinations(Consumer<PipelineDestination.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

