/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.osis.DefaultOsisClientBuilder;
import software.amazon.awssdk.services.osis.OsisClientBuilder;
import software.amazon.awssdk.services.osis.OsisServiceClientConfiguration;
import software.amazon.awssdk.services.osis.model.AccessDeniedException;
import software.amazon.awssdk.services.osis.model.ConflictException;
import software.amazon.awssdk.services.osis.model.CreatePipelineRequest;
import software.amazon.awssdk.services.osis.model.CreatePipelineResponse;
import software.amazon.awssdk.services.osis.model.DeletePipelineRequest;
import software.amazon.awssdk.services.osis.model.DeletePipelineResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineBlueprintRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineBlueprintResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineResponse;
import software.amazon.awssdk.services.osis.model.InternalException;
import software.amazon.awssdk.services.osis.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.osis.model.LimitExceededException;
import software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsResponse;
import software.amazon.awssdk.services.osis.model.ListPipelinesRequest;
import software.amazon.awssdk.services.osis.model.ListPipelinesResponse;
import software.amazon.awssdk.services.osis.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.osis.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.osis.model.OsisException;
import software.amazon.awssdk.services.osis.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.osis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.osis.model.StartPipelineRequest;
import software.amazon.awssdk.services.osis.model.StartPipelineResponse;
import software.amazon.awssdk.services.osis.model.StopPipelineRequest;
import software.amazon.awssdk.services.osis.model.StopPipelineResponse;
import software.amazon.awssdk.services.osis.model.TagResourceRequest;
import software.amazon.awssdk.services.osis.model.TagResourceResponse;
import software.amazon.awssdk.services.osis.model.UntagResourceRequest;
import software.amazon.awssdk.services.osis.model.UntagResourceResponse;
import software.amazon.awssdk.services.osis.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.osis.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.osis.model.ValidatePipelineRequest;
import software.amazon.awssdk.services.osis.model.ValidatePipelineResponse;
import software.amazon.awssdk.services.osis.model.ValidationException;
import software.amazon.awssdk.services.osis.paginators.ListPipelinesIterable;

@SdkPublicApi
@ThreadSafe
public interface OsisClient
extends AwsClient {
    public static final String SERVICE_NAME = "osis";
    public static final String SERVICE_METADATA_ID = "osis";

    default public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws LimitExceededException, ValidationException, InternalException, AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public CreatePipelineResponse createPipeline(Consumer<CreatePipelineRequest.Builder> createPipelineRequest) throws LimitExceededException, ValidationException, InternalException, AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        return this.createPipeline((CreatePipelineRequest)((Object)((CreatePipelineRequest.Builder)CreatePipelineRequest.builder().applyMutation(createPipelineRequest)).build()));
    }

    default public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public DeletePipelineResponse deletePipeline(Consumer<DeletePipelineRequest.Builder> deletePipelineRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, OsisException {
        return this.deletePipeline((DeletePipelineRequest)((Object)((DeletePipelineRequest.Builder)DeletePipelineRequest.builder().applyMutation(deletePipelineRequest)).build()));
    }

    default public GetPipelineResponse getPipeline(GetPipelineRequest getPipelineRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public GetPipelineResponse getPipeline(Consumer<GetPipelineRequest.Builder> getPipelineRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        return this.getPipeline((GetPipelineRequest)((Object)((GetPipelineRequest.Builder)GetPipelineRequest.builder().applyMutation(getPipelineRequest)).build()));
    }

    default public GetPipelineBlueprintResponse getPipelineBlueprint(GetPipelineBlueprintRequest getPipelineBlueprintRequest) throws AccessDeniedException, InternalException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public GetPipelineBlueprintResponse getPipelineBlueprint(Consumer<GetPipelineBlueprintRequest.Builder> getPipelineBlueprintRequest) throws AccessDeniedException, InternalException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        return this.getPipelineBlueprint((GetPipelineBlueprintRequest)((Object)((GetPipelineBlueprintRequest.Builder)GetPipelineBlueprintRequest.builder().applyMutation(getPipelineBlueprintRequest)).build()));
    }

    default public GetPipelineChangeProgressResponse getPipelineChangeProgress(GetPipelineChangeProgressRequest getPipelineChangeProgressRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public GetPipelineChangeProgressResponse getPipelineChangeProgress(Consumer<GetPipelineChangeProgressRequest.Builder> getPipelineChangeProgressRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        return this.getPipelineChangeProgress((GetPipelineChangeProgressRequest)((Object)((GetPipelineChangeProgressRequest.Builder)GetPipelineChangeProgressRequest.builder().applyMutation(getPipelineChangeProgressRequest)).build()));
    }

    default public ListPipelineBlueprintsResponse listPipelineBlueprints(ListPipelineBlueprintsRequest listPipelineBlueprintsRequest) throws ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public ListPipelineBlueprintsResponse listPipelineBlueprints(Consumer<ListPipelineBlueprintsRequest.Builder> listPipelineBlueprintsRequest) throws ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        return this.listPipelineBlueprints((ListPipelineBlueprintsRequest)((Object)((ListPipelineBlueprintsRequest.Builder)ListPipelineBlueprintsRequest.builder().applyMutation(listPipelineBlueprintsRequest)).build()));
    }

    default public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public ListPipelinesResponse listPipelines(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) throws ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        return this.listPipelines((ListPipelinesRequest)((Object)((ListPipelinesRequest.Builder)ListPipelinesRequest.builder().applyMutation(listPipelinesRequest)).build()));
    }

    default public ListPipelinesIterable listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) throws ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        return new ListPipelinesIterable(this, listPipelinesRequest);
    }

    default public ListPipelinesIterable listPipelinesPaginator(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) throws ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        return this.listPipelinesPaginator((ListPipelinesRequest)((Object)((ListPipelinesRequest.Builder)ListPipelinesRequest.builder().applyMutation(listPipelinesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public StartPipelineResponse startPipeline(StartPipelineRequest startPipelineRequest) throws AccessDeniedException, ConflictException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public StartPipelineResponse startPipeline(Consumer<StartPipelineRequest.Builder> startPipelineRequest) throws AccessDeniedException, ConflictException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        return this.startPipeline((StartPipelineRequest)((Object)((StartPipelineRequest.Builder)StartPipelineRequest.builder().applyMutation(startPipelineRequest)).build()));
    }

    default public StopPipelineResponse stopPipeline(StopPipelineRequest stopPipelineRequest) throws AccessDeniedException, ConflictException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public StopPipelineResponse stopPipeline(Consumer<StopPipelineRequest.Builder> stopPipelineRequest) throws AccessDeniedException, ConflictException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        return this.stopPipeline((StopPipelineRequest)((Object)((StopPipelineRequest.Builder)StopPipelineRequest.builder().applyMutation(stopPipelineRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws LimitExceededException, ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws LimitExceededException, ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ValidationException, ResourceNotFoundException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdatePipelineResponse updatePipeline(UpdatePipelineRequest updatePipelineRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public UpdatePipelineResponse updatePipeline(Consumer<UpdatePipelineRequest.Builder> updatePipelineRequest) throws ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, OsisException {
        return this.updatePipeline((UpdatePipelineRequest)((Object)((UpdatePipelineRequest.Builder)UpdatePipelineRequest.builder().applyMutation(updatePipelineRequest)).build()));
    }

    default public ValidatePipelineResponse validatePipeline(ValidatePipelineRequest validatePipelineRequest) throws AccessDeniedException, InternalException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    default public ValidatePipelineResponse validatePipeline(Consumer<ValidatePipelineRequest.Builder> validatePipelineRequest) throws AccessDeniedException, InternalException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        return this.validatePipeline((ValidatePipelineRequest)((Object)((ValidatePipelineRequest.Builder)ValidatePipelineRequest.builder().applyMutation(validatePipelineRequest)).build()));
    }

    public static OsisClient create() {
        return (OsisClient)OsisClient.builder().build();
    }

    public static OsisClientBuilder builder() {
        return new DefaultOsisClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"osis");
    }

    default public OsisServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

