/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.osis.model.CloudWatchLogDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogPublishingOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogPublishingOptions> {
    private static final SdkField<Boolean> IS_LOGGING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsLoggingEnabled").getter(LogPublishingOptions.getter(LogPublishingOptions::isLoggingEnabled)).setter(LogPublishingOptions.setter(Builder::isLoggingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLoggingEnabled").build()}).build();
    private static final SdkField<CloudWatchLogDestination> CLOUD_WATCH_LOG_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLogDestination").getter(LogPublishingOptions.getter(LogPublishingOptions::cloudWatchLogDestination)).setter(LogPublishingOptions.setter(Builder::cloudWatchLogDestination)).constructor(CloudWatchLogDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_LOGGING_ENABLED_FIELD, CLOUD_WATCH_LOG_DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean isLoggingEnabled;
    private final CloudWatchLogDestination cloudWatchLogDestination;

    private LogPublishingOptions(BuilderImpl builder) {
        this.isLoggingEnabled = builder.isLoggingEnabled;
        this.cloudWatchLogDestination = builder.cloudWatchLogDestination;
    }

    public final Boolean isLoggingEnabled() {
        return this.isLoggingEnabled;
    }

    public final CloudWatchLogDestination cloudWatchLogDestination() {
        return this.cloudWatchLogDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isLoggingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogPublishingOptions)) {
            return false;
        }
        LogPublishingOptions other = (LogPublishingOptions)obj;
        return Objects.equals(this.isLoggingEnabled(), other.isLoggingEnabled()) && Objects.equals(this.cloudWatchLogDestination(), other.cloudWatchLogDestination());
    }

    public final String toString() {
        return ToString.builder((String)"LogPublishingOptions").add("IsLoggingEnabled", (Object)this.isLoggingEnabled()).add("CloudWatchLogDestination", (Object)this.cloudWatchLogDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsLoggingEnabled": {
                return Optional.ofNullable(clazz.cast(this.isLoggingEnabled()));
            }
            case "CloudWatchLogDestination": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogPublishingOptions, T> g) {
        return obj -> g.apply((LogPublishingOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isLoggingEnabled;
        private CloudWatchLogDestination cloudWatchLogDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(LogPublishingOptions model) {
            this.isLoggingEnabled(model.isLoggingEnabled);
            this.cloudWatchLogDestination(model.cloudWatchLogDestination);
        }

        public final Boolean getIsLoggingEnabled() {
            return this.isLoggingEnabled;
        }

        public final void setIsLoggingEnabled(Boolean isLoggingEnabled) {
            this.isLoggingEnabled = isLoggingEnabled;
        }

        @Override
        public final Builder isLoggingEnabled(Boolean isLoggingEnabled) {
            this.isLoggingEnabled = isLoggingEnabled;
            return this;
        }

        public final CloudWatchLogDestination.Builder getCloudWatchLogDestination() {
            return this.cloudWatchLogDestination != null ? this.cloudWatchLogDestination.toBuilder() : null;
        }

        public final void setCloudWatchLogDestination(CloudWatchLogDestination.BuilderImpl cloudWatchLogDestination) {
            this.cloudWatchLogDestination = cloudWatchLogDestination != null ? cloudWatchLogDestination.build() : null;
        }

        @Override
        public final Builder cloudWatchLogDestination(CloudWatchLogDestination cloudWatchLogDestination) {
            this.cloudWatchLogDestination = cloudWatchLogDestination;
            return this;
        }

        public LogPublishingOptions build() {
            return new LogPublishingOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogPublishingOptions> {
        public Builder isLoggingEnabled(Boolean var1);

        public Builder cloudWatchLogDestination(CloudWatchLogDestination var1);

        default public Builder cloudWatchLogDestination(Consumer<CloudWatchLogDestination.Builder> cloudWatchLogDestination) {
            return this.cloudWatchLogDestination((CloudWatchLogDestination)((CloudWatchLogDestination.Builder)CloudWatchLogDestination.builder().applyMutation(cloudWatchLogDestination)).build());
        }
    }
}

