/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MoveAccountRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, MoveAccountRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MoveAccountRequest.getter(MoveAccountRequest::accountId)).setter(MoveAccountRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> SOURCE_PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MoveAccountRequest.getter(MoveAccountRequest::sourceParentId)).setter(MoveAccountRequest.setter(Builder::sourceParentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParentId").build()}).build();
    private static final SdkField<String> DESTINATION_PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MoveAccountRequest.getter(MoveAccountRequest::destinationParentId)).setter(MoveAccountRequest.setter(Builder::destinationParentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationParentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, SOURCE_PARENT_ID_FIELD, DESTINATION_PARENT_ID_FIELD));
    private final String accountId;
    private final String sourceParentId;
    private final String destinationParentId;

    private MoveAccountRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.sourceParentId = builder.sourceParentId;
        this.destinationParentId = builder.destinationParentId;
    }

    public String accountId() {
        return this.accountId;
    }

    public String sourceParentId() {
        return this.sourceParentId;
    }

    public String destinationParentId() {
        return this.destinationParentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceParentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationParentId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveAccountRequest)) {
            return false;
        }
        MoveAccountRequest other = (MoveAccountRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.sourceParentId(), other.sourceParentId()) && Objects.equals(this.destinationParentId(), other.destinationParentId());
    }

    public String toString() {
        return ToString.builder((String)"MoveAccountRequest").add("AccountId", (Object)this.accountId()).add("SourceParentId", (Object)this.sourceParentId()).add("DestinationParentId", (Object)this.destinationParentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "SourceParentId": {
                return Optional.ofNullable(clazz.cast(this.sourceParentId()));
            }
            case "DestinationParentId": {
                return Optional.ofNullable(clazz.cast(this.destinationParentId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MoveAccountRequest, T> g) {
        return obj -> g.apply((MoveAccountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String sourceParentId;
        private String destinationParentId;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveAccountRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.sourceParentId(model.sourceParentId);
            this.destinationParentId(model.destinationParentId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getSourceParentId() {
            return this.sourceParentId;
        }

        @Override
        public final Builder sourceParentId(String sourceParentId) {
            this.sourceParentId = sourceParentId;
            return this;
        }

        public final void setSourceParentId(String sourceParentId) {
            this.sourceParentId = sourceParentId;
        }

        public final String getDestinationParentId() {
            return this.destinationParentId;
        }

        @Override
        public final Builder destinationParentId(String destinationParentId) {
            this.destinationParentId = destinationParentId;
            return this;
        }

        public final void setDestinationParentId(String destinationParentId) {
            this.destinationParentId = destinationParentId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MoveAccountRequest build() {
            return new MoveAccountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MoveAccountRequest> {
        public Builder accountId(String var1);

        public Builder sourceParentId(String var1);

        public Builder destinationParentId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

