/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.ChildType;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChildrenRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, ListChildrenRequest> {
    private static final SdkField<String> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListChildrenRequest.getter(ListChildrenRequest::parentId)).setter(ListChildrenRequest.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()}).build();
    private static final SdkField<String> CHILD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListChildrenRequest.getter(ListChildrenRequest::childTypeAsString)).setter(ListChildrenRequest.setter(Builder::childType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListChildrenRequest.getter(ListChildrenRequest::nextToken)).setter(ListChildrenRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListChildrenRequest.getter(ListChildrenRequest::maxResults)).setter(ListChildrenRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_ID_FIELD, CHILD_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String parentId;
    private final String childType;
    private final String nextToken;
    private final Integer maxResults;

    private ListChildrenRequest(BuilderImpl builder) {
        super(builder);
        this.parentId = builder.parentId;
        this.childType = builder.childType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String parentId() {
        return this.parentId;
    }

    public ChildType childType() {
        return ChildType.fromValue(this.childType);
    }

    public String childTypeAsString() {
        return this.childType;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.childTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChildrenRequest)) {
            return false;
        }
        ListChildrenRequest other = (ListChildrenRequest)((Object)obj);
        return Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.childTypeAsString(), other.childTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListChildrenRequest").add("ParentId", (Object)this.parentId()).add("ChildType", (Object)this.childTypeAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "ChildType": {
                return Optional.ofNullable(clazz.cast(this.childTypeAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChildrenRequest, T> g) {
        return obj -> g.apply((ListChildrenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private String parentId;
        private String childType;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChildrenRequest model) {
            super(model);
            this.parentId(model.parentId);
            this.childType(model.childType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getChildTypeAsString() {
            return this.childType;
        }

        @Override
        public final Builder childType(String childType) {
            this.childType = childType;
            return this;
        }

        @Override
        public final Builder childType(ChildType childType) {
            this.childType(childType.toString());
            return this;
        }

        public final void setChildType(String childType) {
            this.childType = childType;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChildrenRequest build() {
            return new ListChildrenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChildrenRequest> {
        public Builder parentId(String var1);

        public Builder childType(String var1);

        public Builder childType(ChildType var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

