/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.Account;
import software.amazon.awssdk.services.organizations.model.ListAccountsWithInvalidEffectivePolicyRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsWithInvalidEffectivePolicyResponse;

public class ListAccountsWithInvalidEffectivePolicyPublisher
implements SdkPublisher<ListAccountsWithInvalidEffectivePolicyResponse> {
    private final OrganizationsAsyncClient client;
    private final ListAccountsWithInvalidEffectivePolicyRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountsWithInvalidEffectivePolicyPublisher(OrganizationsAsyncClient client, ListAccountsWithInvalidEffectivePolicyRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountsWithInvalidEffectivePolicyPublisher(OrganizationsAsyncClient client, ListAccountsWithInvalidEffectivePolicyRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountsWithInvalidEffectivePolicyResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountsWithInvalidEffectivePolicyResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Account> accounts() {
        Function<ListAccountsWithInvalidEffectivePolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.accounts() != null) {
                return response.accounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountsWithInvalidEffectivePolicyResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountsWithInvalidEffectivePolicyResponseFetcher
    implements AsyncPageFetcher<ListAccountsWithInvalidEffectivePolicyResponse> {
        private ListAccountsWithInvalidEffectivePolicyResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsWithInvalidEffectivePolicyResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountsWithInvalidEffectivePolicyResponse> nextPage(ListAccountsWithInvalidEffectivePolicyResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsWithInvalidEffectivePolicyPublisher.this.client.listAccountsWithInvalidEffectivePolicy(ListAccountsWithInvalidEffectivePolicyPublisher.this.firstRequest);
            }
            return ListAccountsWithInvalidEffectivePolicyPublisher.this.client.listAccountsWithInvalidEffectivePolicy((ListAccountsWithInvalidEffectivePolicyRequest)((Object)ListAccountsWithInvalidEffectivePolicyPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

