/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.AccountJoinedMethod;
import software.amazon.awssdk.services.organizations.model.AccountStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DelegatedAdministrator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DelegatedAdministrator> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DelegatedAdministrator.getter(DelegatedAdministrator::id)).setter(DelegatedAdministrator.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DelegatedAdministrator.getter(DelegatedAdministrator::arn)).setter(DelegatedAdministrator.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(DelegatedAdministrator.getter(DelegatedAdministrator::email)).setter(DelegatedAdministrator.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DelegatedAdministrator.getter(DelegatedAdministrator::name)).setter(DelegatedAdministrator.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DelegatedAdministrator.getter(DelegatedAdministrator::statusAsString)).setter(DelegatedAdministrator.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> JOINED_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JoinedMethod").getter(DelegatedAdministrator.getter(DelegatedAdministrator::joinedMethodAsString)).setter(DelegatedAdministrator.setter(Builder::joinedMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinedMethod").build()}).build();
    private static final SdkField<Instant> JOINED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JoinedTimestamp").getter(DelegatedAdministrator.getter(DelegatedAdministrator::joinedTimestamp)).setter(DelegatedAdministrator.setter(Builder::joinedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinedTimestamp").build()}).build();
    private static final SdkField<Instant> DELEGATION_ENABLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DelegationEnabledDate").getter(DelegatedAdministrator.getter(DelegatedAdministrator::delegationEnabledDate)).setter(DelegatedAdministrator.setter(Builder::delegationEnabledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationEnabledDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, EMAIL_FIELD, NAME_FIELD, STATUS_FIELD, JOINED_METHOD_FIELD, JOINED_TIMESTAMP_FIELD, DELEGATION_ENABLED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DelegatedAdministrator.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String email;
    private final String name;
    private final String status;
    private final String joinedMethod;
    private final Instant joinedTimestamp;
    private final Instant delegationEnabledDate;

    private DelegatedAdministrator(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.email = builder.email;
        this.name = builder.name;
        this.status = builder.status;
        this.joinedMethod = builder.joinedMethod;
        this.joinedTimestamp = builder.joinedTimestamp;
        this.delegationEnabledDate = builder.delegationEnabledDate;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String email() {
        return this.email;
    }

    public final String name() {
        return this.name;
    }

    public final AccountStatus status() {
        return AccountStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final AccountJoinedMethod joinedMethod() {
        return AccountJoinedMethod.fromValue(this.joinedMethod);
    }

    public final String joinedMethodAsString() {
        return this.joinedMethod;
    }

    public final Instant joinedTimestamp() {
        return this.joinedTimestamp;
    }

    public final Instant delegationEnabledDate() {
        return this.delegationEnabledDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.joinedMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.joinedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationEnabledDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegatedAdministrator)) {
            return false;
        }
        DelegatedAdministrator other = (DelegatedAdministrator)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.joinedMethodAsString(), other.joinedMethodAsString()) && Objects.equals(this.joinedTimestamp(), other.joinedTimestamp()) && Objects.equals(this.delegationEnabledDate(), other.delegationEnabledDate());
    }

    public final String toString() {
        return ToString.builder((String)"DelegatedAdministrator").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("JoinedMethod", (Object)this.joinedMethodAsString()).add("JoinedTimestamp", (Object)this.joinedTimestamp()).add("DelegationEnabledDate", (Object)this.delegationEnabledDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "JoinedMethod": {
                return Optional.ofNullable(clazz.cast(this.joinedMethodAsString()));
            }
            case "JoinedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.joinedTimestamp()));
            }
            case "DelegationEnabledDate": {
                return Optional.ofNullable(clazz.cast(this.delegationEnabledDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Email", EMAIL_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("JoinedMethod", JOINED_METHOD_FIELD);
        map.put("JoinedTimestamp", JOINED_TIMESTAMP_FIELD);
        map.put("DelegationEnabledDate", DELEGATION_ENABLED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DelegatedAdministrator, T> g) {
        return obj -> g.apply((DelegatedAdministrator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String email;
        private String name;
        private String status;
        private String joinedMethod;
        private Instant joinedTimestamp;
        private Instant delegationEnabledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DelegatedAdministrator model) {
            this.id(model.id);
            this.arn(model.arn);
            this.email(model.email);
            this.name(model.name);
            this.status(model.status);
            this.joinedMethod(model.joinedMethod);
            this.joinedTimestamp(model.joinedTimestamp);
            this.delegationEnabledDate(model.delegationEnabledDate);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AccountStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getJoinedMethod() {
            return this.joinedMethod;
        }

        public final void setJoinedMethod(String joinedMethod) {
            this.joinedMethod = joinedMethod;
        }

        @Override
        public final Builder joinedMethod(String joinedMethod) {
            this.joinedMethod = joinedMethod;
            return this;
        }

        @Override
        public final Builder joinedMethod(AccountJoinedMethod joinedMethod) {
            this.joinedMethod(joinedMethod == null ? null : joinedMethod.toString());
            return this;
        }

        public final Instant getJoinedTimestamp() {
            return this.joinedTimestamp;
        }

        public final void setJoinedTimestamp(Instant joinedTimestamp) {
            this.joinedTimestamp = joinedTimestamp;
        }

        @Override
        public final Builder joinedTimestamp(Instant joinedTimestamp) {
            this.joinedTimestamp = joinedTimestamp;
            return this;
        }

        public final Instant getDelegationEnabledDate() {
            return this.delegationEnabledDate;
        }

        public final void setDelegationEnabledDate(Instant delegationEnabledDate) {
            this.delegationEnabledDate = delegationEnabledDate;
        }

        @Override
        public final Builder delegationEnabledDate(Instant delegationEnabledDate) {
            this.delegationEnabledDate = delegationEnabledDate;
            return this;
        }

        public DelegatedAdministrator build() {
            return new DelegatedAdministrator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DelegatedAdministrator> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder email(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(AccountStatus var1);

        public Builder joinedMethod(String var1);

        public Builder joinedMethod(AccountJoinedMethod var1);

        public Builder joinedTimestamp(Instant var1);

        public Builder delegationEnabledDate(Instant var1);
    }
}

