/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnit;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnitsCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrganizationalUnitsForParentResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListOrganizationalUnitsForParentResponse> {
    private static final SdkField<List<OrganizationalUnit>> ORGANIZATIONAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationalUnits").getter(ListOrganizationalUnitsForParentResponse.getter(ListOrganizationalUnitsForParentResponse::organizationalUnits)).setter(ListOrganizationalUnitsForParentResponse.setter(Builder::organizationalUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationalUnit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOrganizationalUnitsForParentResponse.getter(ListOrganizationalUnitsForParentResponse::nextToken)).setter(ListOrganizationalUnitsForParentResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATIONAL_UNITS_FIELD, NEXT_TOKEN_FIELD));
    private final List<OrganizationalUnit> organizationalUnits;
    private final String nextToken;

    private ListOrganizationalUnitsForParentResponse(BuilderImpl builder) {
        super(builder);
        this.organizationalUnits = builder.organizationalUnits;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOrganizationalUnits() {
        return this.organizationalUnits != null && !(this.organizationalUnits instanceof SdkAutoConstructList);
    }

    public final List<OrganizationalUnit> organizationalUnits() {
        return this.organizationalUnits;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnits() ? this.organizationalUnits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationalUnitsForParentResponse)) {
            return false;
        }
        ListOrganizationalUnitsForParentResponse other = (ListOrganizationalUnitsForParentResponse)((Object)obj);
        return this.hasOrganizationalUnits() == other.hasOrganizationalUnits() && Objects.equals(this.organizationalUnits(), other.organizationalUnits()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrganizationalUnitsForParentResponse").add("OrganizationalUnits", this.hasOrganizationalUnits() ? this.organizationalUnits() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationalUnits": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnits()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationalUnitsForParentResponse, T> g) {
        return obj -> g.apply((ListOrganizationalUnitsForParentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<OrganizationalUnit> organizationalUnits = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationalUnitsForParentResponse model) {
            super(model);
            this.organizationalUnits(model.organizationalUnits);
            this.nextToken(model.nextToken);
        }

        public final List<OrganizationalUnit.Builder> getOrganizationalUnits() {
            List<OrganizationalUnit.Builder> result = OrganizationalUnitsCopier.copyToBuilder(this.organizationalUnits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationalUnits(Collection<OrganizationalUnit.BuilderImpl> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copyFromBuilder(organizationalUnits);
        }

        @Override
        public final Builder organizationalUnits(Collection<OrganizationalUnit> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copy(organizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(OrganizationalUnit ... organizationalUnits) {
            this.organizationalUnits(Arrays.asList(organizationalUnits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(Consumer<OrganizationalUnit.Builder> ... organizationalUnits) {
            this.organizationalUnits(Stream.of(organizationalUnits).map(c -> (OrganizationalUnit)((OrganizationalUnit.Builder)OrganizationalUnit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOrganizationalUnitsForParentResponse build() {
            return new ListOrganizationalUnitsForParentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrganizationalUnitsForParentResponse> {
        public Builder organizationalUnits(Collection<OrganizationalUnit> var1);

        public Builder organizationalUnits(OrganizationalUnit ... var1);

        public Builder organizationalUnits(Consumer<OrganizationalUnit.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

