/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse;

public class ListAWSServiceAccessForOrganizationPublisher
implements SdkPublisher<ListAwsServiceAccessForOrganizationResponse> {
    private final OrganizationsAsyncClient client;
    private final ListAwsServiceAccessForOrganizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAWSServiceAccessForOrganizationPublisher(OrganizationsAsyncClient client, ListAwsServiceAccessForOrganizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAWSServiceAccessForOrganizationPublisher(OrganizationsAsyncClient client, ListAwsServiceAccessForOrganizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAwsServiceAccessForOrganizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAwsServiceAccessForOrganizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAwsServiceAccessForOrganizationResponseFetcher
    implements AsyncPageFetcher<ListAwsServiceAccessForOrganizationResponse> {
        private ListAwsServiceAccessForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListAwsServiceAccessForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAwsServiceAccessForOrganizationResponse> nextPage(ListAwsServiceAccessForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListAWSServiceAccessForOrganizationPublisher.this.client.listAWSServiceAccessForOrganization(ListAWSServiceAccessForOrganizationPublisher.this.firstRequest);
            }
            return ListAWSServiceAccessForOrganizationPublisher.this.client.listAWSServiceAccessForOrganization((ListAwsServiceAccessForOrganizationRequest)((Object)ListAWSServiceAccessForOrganizationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

