/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InvalidInputExceptionReason {
    INVALID_PARTY_TYPE_TARGET("INVALID_PARTY_TYPE_TARGET"),
    INVALID_SYNTAX_ORGANIZATION_ARN("INVALID_SYNTAX_ORGANIZATION_ARN"),
    INVALID_SYNTAX_POLICY_ID("INVALID_SYNTAX_POLICY_ID"),
    INVALID_ENUM("INVALID_ENUM"),
    INVALID_ENUM_POLICY_TYPE("INVALID_ENUM_POLICY_TYPE"),
    INVALID_LIST_MEMBER("INVALID_LIST_MEMBER"),
    MAX_LENGTH_EXCEEDED("MAX_LENGTH_EXCEEDED"),
    MAX_VALUE_EXCEEDED("MAX_VALUE_EXCEEDED"),
    MIN_LENGTH_EXCEEDED("MIN_LENGTH_EXCEEDED"),
    MIN_VALUE_EXCEEDED("MIN_VALUE_EXCEEDED"),
    IMMUTABLE_POLICY("IMMUTABLE_POLICY"),
    INVALID_PATTERN("INVALID_PATTERN"),
    INVALID_PATTERN_TARGET_ID("INVALID_PATTERN_TARGET_ID"),
    INPUT_REQUIRED("INPUT_REQUIRED"),
    INVALID_NEXT_TOKEN("INVALID_NEXT_TOKEN"),
    MAX_LIMIT_EXCEEDED_FILTER("MAX_LIMIT_EXCEEDED_FILTER"),
    MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS("MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS"),
    INVALID_FULL_NAME_TARGET("INVALID_FULL_NAME_TARGET"),
    UNRECOGNIZED_SERVICE_PRINCIPAL("UNRECOGNIZED_SERVICE_PRINCIPAL"),
    INVALID_ROLE_NAME("INVALID_ROLE_NAME"),
    INVALID_SYSTEM_TAGS_PARAMETER("INVALID_SYSTEM_TAGS_PARAMETER"),
    DUPLICATE_TAG_KEY("DUPLICATE_TAG_KEY"),
    TARGET_NOT_SUPPORTED("TARGET_NOT_SUPPORTED"),
    INVALID_EMAIL_ADDRESS_TARGET("INVALID_EMAIL_ADDRESS_TARGET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InvalidInputExceptionReason> VALUE_MAP;
    private final String value;

    private InvalidInputExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InvalidInputExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InvalidInputExceptionReason> knownValues() {
        EnumSet<InvalidInputExceptionReason> knownValues = EnumSet.allOf(InvalidInputExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InvalidInputExceptionReason.class, InvalidInputExceptionReason::toString);
    }
}

