/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParentType {
    ROOT("ROOT"),
    ORGANIZATIONAL_UNIT("ORGANIZATIONAL_UNIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParentType> VALUE_MAP;
    private final String value;

    private ParentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParentType> knownValues() {
        EnumSet<ParentType> knownValues = EnumSet.allOf(ParentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParentType.class, ParentType::toString);
    }
}

