/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DelegatedService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DelegatedService> {
    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServicePrincipal").getter(DelegatedService.getter(DelegatedService::servicePrincipal)).setter(DelegatedService.setter(Builder::servicePrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipal").build()}).build();
    private static final SdkField<Instant> DELEGATION_ENABLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DelegationEnabledDate").getter(DelegatedService.getter(DelegatedService::delegationEnabledDate)).setter(DelegatedService.setter(Builder::delegationEnabledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationEnabledDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_PRINCIPAL_FIELD, DELEGATION_ENABLED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String servicePrincipal;
    private final Instant delegationEnabledDate;

    private DelegatedService(BuilderImpl builder) {
        this.servicePrincipal = builder.servicePrincipal;
        this.delegationEnabledDate = builder.delegationEnabledDate;
    }

    public final String servicePrincipal() {
        return this.servicePrincipal;
    }

    public final Instant delegationEnabledDate() {
        return this.delegationEnabledDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.servicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationEnabledDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegatedService)) {
            return false;
        }
        DelegatedService other = (DelegatedService)obj;
        return Objects.equals(this.servicePrincipal(), other.servicePrincipal()) && Objects.equals(this.delegationEnabledDate(), other.delegationEnabledDate());
    }

    public final String toString() {
        return ToString.builder((String)"DelegatedService").add("ServicePrincipal", (Object)this.servicePrincipal()).add("DelegationEnabledDate", (Object)this.delegationEnabledDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServicePrincipal": {
                return Optional.ofNullable(clazz.cast(this.servicePrincipal()));
            }
            case "DelegationEnabledDate": {
                return Optional.ofNullable(clazz.cast(this.delegationEnabledDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DelegatedService, T> g) {
        return obj -> g.apply((DelegatedService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String servicePrincipal;
        private Instant delegationEnabledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DelegatedService model) {
            this.servicePrincipal(model.servicePrincipal);
            this.delegationEnabledDate(model.delegationEnabledDate);
        }

        public final String getServicePrincipal() {
            return this.servicePrincipal;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public final Instant getDelegationEnabledDate() {
            return this.delegationEnabledDate;
        }

        public final void setDelegationEnabledDate(Instant delegationEnabledDate) {
            this.delegationEnabledDate = delegationEnabledDate;
        }

        @Override
        public final Builder delegationEnabledDate(Instant delegationEnabledDate) {
            this.delegationEnabledDate = delegationEnabledDate;
            return this;
        }

        public DelegatedService build() {
            return new DelegatedService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DelegatedService> {
        public Builder servicePrincipal(String var1);

        public Builder delegationEnabledDate(Instant var1);
    }
}

