/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CreateAccountFailureReason {
    ACCOUNT_LIMIT_EXCEEDED("ACCOUNT_LIMIT_EXCEEDED"),
    EMAIL_ALREADY_EXISTS("EMAIL_ALREADY_EXISTS"),
    INVALID_ADDRESS("INVALID_ADDRESS"),
    INVALID_EMAIL("INVALID_EMAIL"),
    CONCURRENT_ACCOUNT_MODIFICATION("CONCURRENT_ACCOUNT_MODIFICATION"),
    INTERNAL_FAILURE("INTERNAL_FAILURE"),
    GOVCLOUD_ACCOUNT_ALREADY_EXISTS("GOVCLOUD_ACCOUNT_ALREADY_EXISTS"),
    MISSING_BUSINESS_VALIDATION("MISSING_BUSINESS_VALIDATION"),
    FAILED_BUSINESS_VALIDATION("FAILED_BUSINESS_VALIDATION"),
    PENDING_BUSINESS_VALIDATION("PENDING_BUSINESS_VALIDATION"),
    INVALID_IDENTITY_FOR_BUSINESS_VALIDATION("INVALID_IDENTITY_FOR_BUSINESS_VALIDATION"),
    UNKNOWN_BUSINESS_VALIDATION("UNKNOWN_BUSINESS_VALIDATION"),
    MISSING_PAYMENT_INSTRUMENT("MISSING_PAYMENT_INSTRUMENT"),
    INVALID_PAYMENT_INSTRUMENT("INVALID_PAYMENT_INSTRUMENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CreateAccountFailureReason> VALUE_MAP;
    private final String value;

    private CreateAccountFailureReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CreateAccountFailureReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CreateAccountFailureReason> knownValues() {
        EnumSet<CreateAccountFailureReason> knownValues = EnumSet.allOf(CreateAccountFailureReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CreateAccountFailureReason.class, CreateAccountFailureReason::toString);
    }
}

