/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse;

public class ListHandshakesForAccountIterable
implements SdkIterable<ListHandshakesForAccountResponse> {
    private final OrganizationsClient client;
    private final ListHandshakesForAccountRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHandshakesForAccountIterable(OrganizationsClient client, ListHandshakesForAccountRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHandshakesForAccountResponseFetcher();
    }

    public Iterator<ListHandshakesForAccountResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListHandshakesForAccountResponseFetcher
    implements SyncPageFetcher<ListHandshakesForAccountResponse> {
        private ListHandshakesForAccountResponseFetcher() {
        }

        public boolean hasNextPage(ListHandshakesForAccountResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHandshakesForAccountResponse nextPage(ListHandshakesForAccountResponse previousPage) {
            if (previousPage == null) {
                return ListHandshakesForAccountIterable.this.client.listHandshakesForAccount(ListHandshakesForAccountIterable.this.firstRequest);
            }
            return ListHandshakesForAccountIterable.this.client.listHandshakesForAccount((ListHandshakesForAccountRequest)((Object)ListHandshakesForAccountIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

