/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum InvalidInputExceptionReason {
    INVALID_PARTY_TYPE_TARGET("INVALID_PARTY_TYPE_TARGET"),

    INVALID_SYNTAX_ORGANIZATION_ARN("INVALID_SYNTAX_ORGANIZATION_ARN"),

    INVALID_SYNTAX_POLICY_ID("INVALID_SYNTAX_POLICY_ID"),

    INVALID_ENUM("INVALID_ENUM"),

    INVALID_ENUM_POLICY_TYPE("INVALID_ENUM_POLICY_TYPE"),

    INVALID_LIST_MEMBER("INVALID_LIST_MEMBER"),

    MAX_LENGTH_EXCEEDED("MAX_LENGTH_EXCEEDED"),

    MAX_VALUE_EXCEEDED("MAX_VALUE_EXCEEDED"),

    MIN_LENGTH_EXCEEDED("MIN_LENGTH_EXCEEDED"),

    MIN_VALUE_EXCEEDED("MIN_VALUE_EXCEEDED"),

    IMMUTABLE_POLICY("IMMUTABLE_POLICY"),

    INVALID_PATTERN("INVALID_PATTERN"),

    INVALID_PATTERN_TARGET_ID("INVALID_PATTERN_TARGET_ID"),

    INPUT_REQUIRED("INPUT_REQUIRED"),

    INVALID_NEXT_TOKEN("INVALID_NEXT_TOKEN"),

    MAX_LIMIT_EXCEEDED_FILTER("MAX_LIMIT_EXCEEDED_FILTER"),

    MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS("MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS"),

    INVALID_FULL_NAME_TARGET("INVALID_FULL_NAME_TARGET"),

    UNRECOGNIZED_SERVICE_PRINCIPAL("UNRECOGNIZED_SERVICE_PRINCIPAL"),

    INVALID_ROLE_NAME("INVALID_ROLE_NAME"),

    INVALID_SYSTEM_TAGS_PARAMETER("INVALID_SYSTEM_TAGS_PARAMETER"),

    DUPLICATE_TAG_KEY("DUPLICATE_TAG_KEY"),

    TARGET_NOT_SUPPORTED("TARGET_NOT_SUPPORTED"),

    INVALID_EMAIL_ADDRESS_TARGET("INVALID_EMAIL_ADDRESS_TARGET"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InvalidInputExceptionReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return InvalidInputExceptionReason corresponding to the value
     */
    public static InvalidInputExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InvalidInputExceptionReason.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link InvalidInputExceptionReason}s
     */
    public static Set<InvalidInputExceptionReason> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
