/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The requested operation would violate the constraint identified in the reason code.
 * </p>
 * <note>
 * <p>
 * Some of the reasons in the following list might not be applicable to this specific API or operation:
 * </p>
 * </note>
 * <ul>
 * <li>
 * <p>
 * ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the number of accounts in an organization. Note
 * that deleted and closed accounts still count toward your limit.
 * </p>
 * <important>
 * <p>
 * If you get this exception immediately after creating the organization, wait one hour and try again. If after an hour
 * it continues to fail with this error, contact <a href="https://console.aws.amazon.com/support/home#/">AWS
 * Support</a>.
 * </p>
 * </important></li>
 * <li>
 * <p>
 * ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because the invited account is already a member of an
 * organization.
 * </p>
 * </li>
 * <li>
 * <p>
 * HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of handshakes that you can send in one day.
 * </p>
 * </li>
 * <li>
 * <p>
 * INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations to join an organization while it's in the
 * process of enabling all features. You can resume inviting accounts after you finalize the process when all accounts
 * have agreed to the change.
 * </p>
 * </li>
 * <li>
 * <p>
 * ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid because the organization has already enabled
 * all features.
 * </p>
 * </li>
 * <li>
 * <p>
 * ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION: The handshake request is invalid because the organization has
 * already started the process to enable all features.
 * </p>
 * </li>
 * <li>
 * <p>
 * ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because the account is from a different marketplace
 * than the accounts in the organization. For example, accounts with India addresses must be associated with the AISPL
 * marketplace. All accounts in an organization must be from the same marketplace.
 * </p>
 * </li>
 * <li>
 * <p>
 * ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to change the membership of an account too quickly
 * after its previous change.
 * </p>
 * </li>
 * <li>
 * <p>
 * PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an account that doesn't have a payment instrument,
 * such as a credit card, associated with it.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HandshakeConstraintViolationException extends OrganizationsException implements
        ToCopyableBuilder<HandshakeConstraintViolationException.Builder, HandshakeConstraintViolationException> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(HandshakeConstraintViolationException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reason;

    private HandshakeConstraintViolationException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Reason property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link HandshakeConstraintViolationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The value of the Reason property for this object.
     * @see HandshakeConstraintViolationExceptionReason
     */
    public HandshakeConstraintViolationExceptionReason reason() {
        return HandshakeConstraintViolationExceptionReason.fromValue(reason);
    }

    /**
     * Returns the value of the Reason property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link HandshakeConstraintViolationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The value of the Reason property for this object.
     * @see HandshakeConstraintViolationExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HandshakeConstraintViolationException, T> g) {
        return obj -> g.apply((HandshakeConstraintViolationException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HandshakeConstraintViolationException>,
            OrganizationsException.Builder {
        /**
         * Sets the value of the Reason property for this object.
         *
         * @param reason
         *        The new value for the Reason property for this object.
         * @see HandshakeConstraintViolationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandshakeConstraintViolationExceptionReason
         */
        Builder reason(String reason);

        /**
         * Sets the value of the Reason property for this object.
         *
         * @param reason
         *        The new value for the Reason property for this object.
         * @see HandshakeConstraintViolationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandshakeConstraintViolationExceptionReason
         */
        Builder reason(HandshakeConstraintViolationExceptionReason reason);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends OrganizationsException.BuilderImpl implements Builder {
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeConstraintViolationException model) {
            super(model);
            reason(model.reason);
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(HandshakeConstraintViolationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public HandshakeConstraintViolationException build() {
            return new HandshakeConstraintViolationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
