/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptHandshakeResponse extends OrganizationsResponse implements
        ToCopyableBuilder<AcceptHandshakeResponse.Builder, AcceptHandshakeResponse> {
    private static final SdkField<Handshake> HANDSHAKE_FIELD = SdkField.<Handshake> builder(MarshallingType.SDK_POJO)
            .memberName("Handshake").getter(getter(AcceptHandshakeResponse::handshake)).setter(setter(Builder::handshake))
            .constructor(Handshake::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handshake").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HANDSHAKE_FIELD));

    private final Handshake handshake;

    private AcceptHandshakeResponse(BuilderImpl builder) {
        super(builder);
        this.handshake = builder.handshake;
    }

    /**
     * <p>
     * A structure that contains details about the accepted handshake.
     * </p>
     * 
     * @return A structure that contains details about the accepted handshake.
     */
    public final Handshake handshake() {
        return handshake;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(handshake());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptHandshakeResponse)) {
            return false;
        }
        AcceptHandshakeResponse other = (AcceptHandshakeResponse) obj;
        return Objects.equals(handshake(), other.handshake());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptHandshakeResponse").add("Handshake", handshake()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Handshake":
            return Optional.ofNullable(clazz.cast(handshake()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptHandshakeResponse, T> g) {
        return obj -> g.apply((AcceptHandshakeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo, CopyableBuilder<Builder, AcceptHandshakeResponse> {
        /**
         * <p>
         * A structure that contains details about the accepted handshake.
         * </p>
         * 
         * @param handshake
         *        A structure that contains details about the accepted handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handshake(Handshake handshake);

        /**
         * <p>
         * A structure that contains details about the accepted handshake.
         * </p>
         * This is a convenience that creates an instance of the {@link Handshake.Builder} avoiding the need to create
         * one manually via {@link Handshake#builder()}.
         *
         * When the {@link Consumer} completes, {@link Handshake.Builder#build()} is called immediately and its result
         * is passed to {@link #handshake(Handshake)}.
         * 
         * @param handshake
         *        a consumer that will call methods on {@link Handshake.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #handshake(Handshake)
         */
        default Builder handshake(Consumer<Handshake.Builder> handshake) {
            return handshake(Handshake.builder().applyMutation(handshake).build());
        }
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private Handshake handshake;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptHandshakeResponse model) {
            super(model);
            handshake(model.handshake);
        }

        public final Handshake.Builder getHandshake() {
            return handshake != null ? handshake.toBuilder() : null;
        }

        @Override
        public final Builder handshake(Handshake handshake) {
            this.handshake = handshake;
            return this;
        }

        public final void setHandshake(Handshake.BuilderImpl handshake) {
            this.handshake = handshake != null ? handshake.build() : null;
        }

        @Override
        public AcceptHandshakeResponse build() {
            return new AcceptHandshakeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
