/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HandshakeResourceType {
    ACCOUNT("ACCOUNT"),
    ORGANIZATION("ORGANIZATION"),
    ORGANIZATION_FEATURE_SET("ORGANIZATION_FEATURE_SET"),
    EMAIL("EMAIL"),
    MASTER_EMAIL("MASTER_EMAIL"),
    MASTER_NAME("MASTER_NAME"),
    NOTES("NOTES"),
    PARENT_HANDSHAKE("PARENT_HANDSHAKE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HandshakeResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HandshakeResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HandshakeResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HandshakeResourceType> knownValues() {
        return Stream.of(HandshakeResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

