/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.Child;
import software.amazon.awssdk.services.organizations.model.ChildrenCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChildrenResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListChildrenResponse> {
    private static final SdkField<List<Child>> CHILDREN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Children").getter(ListChildrenResponse.getter(ListChildrenResponse::children)).setter(ListChildrenResponse.setter(Builder::children)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Children").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Child::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChildrenResponse.getter(ListChildrenResponse::nextToken)).setter(ListChildrenResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHILDREN_FIELD, NEXT_TOKEN_FIELD));
    private final List<Child> children;
    private final String nextToken;

    private ListChildrenResponse(BuilderImpl builder) {
        super(builder);
        this.children = builder.children;
        this.nextToken = builder.nextToken;
    }

    public boolean hasChildren() {
        return this.children != null && !(this.children instanceof SdkAutoConstructList);
    }

    public List<Child> children() {
        return this.children;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildren() ? this.children() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChildrenResponse)) {
            return false;
        }
        ListChildrenResponse other = (ListChildrenResponse)((Object)obj);
        return this.hasChildren() == other.hasChildren() && Objects.equals(this.children(), other.children()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListChildrenResponse").add("Children", this.hasChildren() ? this.children() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Children": {
                return Optional.ofNullable(clazz.cast(this.children()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChildrenResponse, T> g) {
        return obj -> g.apply((ListChildrenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<Child> children = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChildrenResponse model) {
            super(model);
            this.children(model.children);
            this.nextToken(model.nextToken);
        }

        public final Collection<Child.Builder> getChildren() {
            if (this.children instanceof SdkAutoConstructList) {
                return null;
            }
            return this.children != null ? (Collection)this.children.stream().map(Child::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder children(Collection<Child> children) {
            this.children = ChildrenCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Child ... children) {
            this.children(Arrays.asList(children));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Consumer<Child.Builder> ... children) {
            this.children(Stream.of(children).map(c -> (Child)((Child.Builder)Child.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChildren(Collection<Child.BuilderImpl> children) {
            this.children = ChildrenCopier.copyFromBuilder(children);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListChildrenResponse build() {
            return new ListChildrenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChildrenResponse> {
        public Builder children(Collection<Child> var1);

        public Builder children(Child ... var1);

        public Builder children(Consumer<Child.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

