/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisablePolicyTypeRequest extends OrganizationsRequest implements
        ToCopyableBuilder<DisablePolicyTypeRequest.Builder, DisablePolicyTypeRequest> {
    private static final SdkField<String> ROOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DisablePolicyTypeRequest::rootId)).setter(setter(Builder::rootId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootId").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DisablePolicyTypeRequest::policyTypeAsString)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOT_ID_FIELD,
            POLICY_TYPE_FIELD));

    private final String rootId;

    private final String policyType;

    private DisablePolicyTypeRequest(BuilderImpl builder) {
        super(builder);
        this.rootId = builder.rootId;
        this.policyType = builder.policyType;
    }

    /**
     * <p>
     * The unique identifier (ID) of the root in which you want to disable a policy type. You can get the ID from the
     * <a>ListRoots</a> operation.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed by
     * from 4 to 32 lowercase letters or digits.
     * </p>
     * 
     * @return The unique identifier (ID) of the root in which you want to disable a policy type. You can get the ID
     *         from the <a>ListRoots</a> operation.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-"
     *         followed by from 4 to 32 lowercase letters or digits.
     */
    public String rootId() {
        return rootId;
    }

    /**
     * <p>
     * The policy type that you want to disable in this root.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The policy type that you want to disable in this root.
     * @see PolicyType
     */
    public PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The policy type that you want to disable in this root.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The policy type that you want to disable in this root.
     * @see PolicyType
     */
    public String policyTypeAsString() {
        return policyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rootId());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisablePolicyTypeRequest)) {
            return false;
        }
        DisablePolicyTypeRequest other = (DisablePolicyTypeRequest) obj;
        return Objects.equals(rootId(), other.rootId()) && Objects.equals(policyTypeAsString(), other.policyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisablePolicyTypeRequest").add("RootId", rootId()).add("PolicyType", policyTypeAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RootId":
            return Optional.ofNullable(clazz.cast(rootId()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisablePolicyTypeRequest, T> g) {
        return obj -> g.apply((DisablePolicyTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisablePolicyTypeRequest> {
        /**
         * <p>
         * The unique identifier (ID) of the root in which you want to disable a policy type. You can get the ID from
         * the <a>ListRoots</a> operation.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-" followed
         * by from 4 to 32 lowercase letters or digits.
         * </p>
         * 
         * @param rootId
         *        The unique identifier (ID) of the root in which you want to disable a policy type. You can get the ID
         *        from the <a>ListRoots</a> operation.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a root ID string requires "r-"
         *        followed by from 4 to 32 lowercase letters or digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootId(String rootId);

        /**
         * <p>
         * The policy type that you want to disable in this root.
         * </p>
         * 
         * @param policyType
         *        The policy type that you want to disable in this root.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The policy type that you want to disable in this root.
         * </p>
         * 
         * @param policyType
         *        The policy type that you want to disable in this root.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String rootId;

        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(DisablePolicyTypeRequest model) {
            super(model);
            rootId(model.rootId);
            policyType(model.policyType);
        }

        public final String getRootId() {
            return rootId;
        }

        @Override
        public final Builder rootId(String rootId) {
            this.rootId = rootId;
            return this;
        }

        public final void setRootId(String rootId) {
            this.rootId = rootId;
        }

        public final String getPolicyType() {
            return policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisablePolicyTypeRequest build() {
            return new DisablePolicyTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
