/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOrganizationalUnitsForParentResponse extends OrganizationsResponse implements
        ToCopyableBuilder<ListOrganizationalUnitsForParentResponse.Builder, ListOrganizationalUnitsForParentResponse> {
    private static final SdkField<List<OrganizationalUnit>> ORGANIZATIONAL_UNITS_FIELD = SdkField
            .<List<OrganizationalUnit>> builder(MarshallingType.LIST)
            .getter(getter(ListOrganizationalUnitsForParentResponse::organizationalUnits))
            .setter(setter(Builder::organizationalUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationalUnit> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationalUnit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOrganizationalUnitsForParentResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATIONAL_UNITS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<OrganizationalUnit> organizationalUnits;

    private final String nextToken;

    private ListOrganizationalUnitsForParentResponse(BuilderImpl builder) {
        super(builder);
        this.organizationalUnits = builder.organizationalUnits;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the OrganizationalUnits property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasOrganizationalUnits() {
        return organizationalUnits != null && !(organizationalUnits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the OUs in the specified root or parent OU.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrganizationalUnits()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the OUs in the specified root or parent OU.
     */
    public List<OrganizationalUnit> organizationalUnits() {
        return organizationalUnits;
    }

    /**
     * <p>
     * If present, this value indicates that there is more output available than is included in the current response.
     * Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     * next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as
     * <code>null</code>.
     * </p>
     * 
     * @return If present, this value indicates that there is more output available than is included in the current
     *         response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
     *         operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
     *         response element comes back as <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnits());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationalUnitsForParentResponse)) {
            return false;
        }
        ListOrganizationalUnitsForParentResponse other = (ListOrganizationalUnitsForParentResponse) obj;
        return Objects.equals(organizationalUnits(), other.organizationalUnits())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListOrganizationalUnitsForParentResponse").add("OrganizationalUnits", organizationalUnits())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationalUnits":
            return Optional.ofNullable(clazz.cast(organizationalUnits()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationalUnitsForParentResponse, T> g) {
        return obj -> g.apply((ListOrganizationalUnitsForParentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOrganizationalUnitsForParentResponse> {
        /**
         * <p>
         * A list of the OUs in the specified root or parent OU.
         * </p>
         * 
         * @param organizationalUnits
         *        A list of the OUs in the specified root or parent OU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnits(Collection<OrganizationalUnit> organizationalUnits);

        /**
         * <p>
         * A list of the OUs in the specified root or parent OU.
         * </p>
         * 
         * @param organizationalUnits
         *        A list of the OUs in the specified root or parent OU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnits(OrganizationalUnit... organizationalUnits);

        /**
         * <p>
         * A list of the OUs in the specified root or parent OU.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OrganizationalUnit>.Builder} avoiding the
         * need to create one manually via {@link List<OrganizationalUnit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrganizationalUnit>.Builder#build()} is called immediately
         * and its result is passed to {@link #organizationalUnits(List<OrganizationalUnit>)}.
         * 
         * @param organizationalUnits
         *        a consumer that will call methods on {@link List<OrganizationalUnit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationalUnits(List<OrganizationalUnit>)
         */
        Builder organizationalUnits(Consumer<OrganizationalUnit.Builder>... organizationalUnits);

        /**
         * <p>
         * If present, this value indicates that there is more output available than is included in the current
         * response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         * operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         * response element comes back as <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, this value indicates that there is more output available than is included in the current
         *        response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         *        operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         *        response element comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private List<OrganizationalUnit> organizationalUnits = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationalUnitsForParentResponse model) {
            super(model);
            organizationalUnits(model.organizationalUnits);
            nextToken(model.nextToken);
        }

        public final Collection<OrganizationalUnit.Builder> getOrganizationalUnits() {
            return organizationalUnits != null ? organizationalUnits.stream().map(OrganizationalUnit::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationalUnits(Collection<OrganizationalUnit> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copy(organizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(OrganizationalUnit... organizationalUnits) {
            organizationalUnits(Arrays.asList(organizationalUnits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(Consumer<OrganizationalUnit.Builder>... organizationalUnits) {
            organizationalUnits(Stream.of(organizationalUnits).map(c -> OrganizationalUnit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationalUnits(Collection<OrganizationalUnit.BuilderImpl> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copyFromBuilder(organizationalUnits);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOrganizationalUnitsForParentResponse build() {
            return new ListOrganizationalUnitsForParentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
