/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHandshakesForOrganizationResponse extends OrganizationsResponse implements
        ToCopyableBuilder<ListHandshakesForOrganizationResponse.Builder, ListHandshakesForOrganizationResponse> {
    private static final SdkField<List<Handshake>> HANDSHAKES_FIELD = SdkField
            .<List<Handshake>> builder(MarshallingType.LIST)
            .getter(getter(ListHandshakesForOrganizationResponse::handshakes))
            .setter(setter(Builder::handshakes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handshakes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Handshake> builder(MarshallingType.SDK_POJO)
                                            .constructor(Handshake::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListHandshakesForOrganizationResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HANDSHAKES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Handshake> handshakes;

    private final String nextToken;

    private ListHandshakesForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.handshakes = builder.handshakes;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Handshakes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHandshakes() {
        return handshakes != null && !(handshakes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>Handshake</a> objects with details about each of the handshakes that are associated with an
     * organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHandshakes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <a>Handshake</a> objects with details about each of the handshakes that are associated with an
     *         organization.
     */
    public List<Handshake> handshakes() {
        return handshakes;
    }

    /**
     * <p>
     * If present, this value indicates that there is more output available than is included in the current response.
     * Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     * next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as
     * <code>null</code>.
     * </p>
     * 
     * @return If present, this value indicates that there is more output available than is included in the current
     *         response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
     *         operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
     *         response element comes back as <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(handshakes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHandshakesForOrganizationResponse)) {
            return false;
        }
        ListHandshakesForOrganizationResponse other = (ListHandshakesForOrganizationResponse) obj;
        return Objects.equals(handshakes(), other.handshakes()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHandshakesForOrganizationResponse").add("Handshakes", handshakes())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Handshakes":
            return Optional.ofNullable(clazz.cast(handshakes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHandshakesForOrganizationResponse, T> g) {
        return obj -> g.apply((ListHandshakesForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListHandshakesForOrganizationResponse> {
        /**
         * <p>
         * A list of <a>Handshake</a> objects with details about each of the handshakes that are associated with an
         * organization.
         * </p>
         * 
         * @param handshakes
         *        A list of <a>Handshake</a> objects with details about each of the handshakes that are associated with
         *        an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handshakes(Collection<Handshake> handshakes);

        /**
         * <p>
         * A list of <a>Handshake</a> objects with details about each of the handshakes that are associated with an
         * organization.
         * </p>
         * 
         * @param handshakes
         *        A list of <a>Handshake</a> objects with details about each of the handshakes that are associated with
         *        an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handshakes(Handshake... handshakes);

        /**
         * <p>
         * A list of <a>Handshake</a> objects with details about each of the handshakes that are associated with an
         * organization.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Handshake>.Builder} avoiding the need to
         * create one manually via {@link List<Handshake>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Handshake>.Builder#build()} is called immediately and its
         * result is passed to {@link #handshakes(List<Handshake>)}.
         * 
         * @param handshakes
         *        a consumer that will call methods on {@link List<Handshake>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #handshakes(List<Handshake>)
         */
        Builder handshakes(Consumer<Handshake.Builder>... handshakes);

        /**
         * <p>
         * If present, this value indicates that there is more output available than is included in the current
         * response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         * operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         * response element comes back as <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, this value indicates that there is more output available than is included in the current
         *        response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         *        operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         *        response element comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private List<Handshake> handshakes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHandshakesForOrganizationResponse model) {
            super(model);
            handshakes(model.handshakes);
            nextToken(model.nextToken);
        }

        public final Collection<Handshake.Builder> getHandshakes() {
            return handshakes != null ? handshakes.stream().map(Handshake::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder handshakes(Collection<Handshake> handshakes) {
            this.handshakes = HandshakesCopier.copy(handshakes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder handshakes(Handshake... handshakes) {
            handshakes(Arrays.asList(handshakes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder handshakes(Consumer<Handshake.Builder>... handshakes) {
            handshakes(Stream.of(handshakes).map(c -> Handshake.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHandshakes(Collection<Handshake.BuilderImpl> handshakes) {
            this.handshakes = HandshakesCopier.copyFromBuilder(handshakes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHandshakesForOrganizationResponse build() {
            return new ListHandshakesForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
