/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCreateAccountStatusResponse extends OrganizationsResponse implements
        ToCopyableBuilder<ListCreateAccountStatusResponse.Builder, ListCreateAccountStatusResponse> {
    private static final SdkField<List<CreateAccountStatus>> CREATE_ACCOUNT_STATUSES_FIELD = SdkField
            .<List<CreateAccountStatus>> builder(MarshallingType.LIST)
            .getter(getter(ListCreateAccountStatusResponse::createAccountStatuses))
            .setter(setter(Builder::createAccountStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAccountStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateAccountStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateAccountStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCreateAccountStatusResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_ACCOUNT_STATUSES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CreateAccountStatus> createAccountStatuses;

    private final String nextToken;

    private ListCreateAccountStatusResponse(BuilderImpl builder) {
        super(builder);
        this.createAccountStatuses = builder.createAccountStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the CreateAccountStatuses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCreateAccountStatuses() {
        return createAccountStatuses != null && !(createAccountStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects with details about the requests. Certain elements, such as the accountId number, are present in
     * the output only after the account has been successfully created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCreateAccountStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of objects with details about the requests. Certain elements, such as the accountId number, are
     *         present in the output only after the account has been successfully created.
     */
    public List<CreateAccountStatus> createAccountStatuses() {
        return createAccountStatuses;
    }

    /**
     * <p>
     * If present, this value indicates that there is more output available than is included in the current response.
     * Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     * next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as
     * <code>null</code>.
     * </p>
     * 
     * @return If present, this value indicates that there is more output available than is included in the current
     *         response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
     *         operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
     *         response element comes back as <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createAccountStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCreateAccountStatusResponse)) {
            return false;
        }
        ListCreateAccountStatusResponse other = (ListCreateAccountStatusResponse) obj;
        return Objects.equals(createAccountStatuses(), other.createAccountStatuses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCreateAccountStatusResponse").add("CreateAccountStatuses", createAccountStatuses())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateAccountStatuses":
            return Optional.ofNullable(clazz.cast(createAccountStatuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCreateAccountStatusResponse, T> g) {
        return obj -> g.apply((ListCreateAccountStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCreateAccountStatusResponse> {
        /**
         * <p>
         * A list of objects with details about the requests. Certain elements, such as the accountId number, are
         * present in the output only after the account has been successfully created.
         * </p>
         * 
         * @param createAccountStatuses
         *        A list of objects with details about the requests. Certain elements, such as the accountId number, are
         *        present in the output only after the account has been successfully created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createAccountStatuses(Collection<CreateAccountStatus> createAccountStatuses);

        /**
         * <p>
         * A list of objects with details about the requests. Certain elements, such as the accountId number, are
         * present in the output only after the account has been successfully created.
         * </p>
         * 
         * @param createAccountStatuses
         *        A list of objects with details about the requests. Certain elements, such as the accountId number, are
         *        present in the output only after the account has been successfully created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createAccountStatuses(CreateAccountStatus... createAccountStatuses);

        /**
         * <p>
         * A list of objects with details about the requests. Certain elements, such as the accountId number, are
         * present in the output only after the account has been successfully created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CreateAccountStatus>.Builder} avoiding the
         * need to create one manually via {@link List<CreateAccountStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreateAccountStatus>.Builder#build()} is called immediately
         * and its result is passed to {@link #createAccountStatuses(List<CreateAccountStatus>)}.
         * 
         * @param createAccountStatuses
         *        a consumer that will call methods on {@link List<CreateAccountStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createAccountStatuses(List<CreateAccountStatus>)
         */
        Builder createAccountStatuses(Consumer<CreateAccountStatus.Builder>... createAccountStatuses);

        /**
         * <p>
         * If present, this value indicates that there is more output available than is included in the current
         * response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         * operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         * response element comes back as <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, this value indicates that there is more output available than is included in the current
         *        response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         *        operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         *        response element comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private List<CreateAccountStatus> createAccountStatuses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCreateAccountStatusResponse model) {
            super(model);
            createAccountStatuses(model.createAccountStatuses);
            nextToken(model.nextToken);
        }

        public final Collection<CreateAccountStatus.Builder> getCreateAccountStatuses() {
            return createAccountStatuses != null ? createAccountStatuses.stream().map(CreateAccountStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createAccountStatuses(Collection<CreateAccountStatus> createAccountStatuses) {
            this.createAccountStatuses = CreateAccountStatusesCopier.copy(createAccountStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createAccountStatuses(CreateAccountStatus... createAccountStatuses) {
            createAccountStatuses(Arrays.asList(createAccountStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createAccountStatuses(Consumer<CreateAccountStatus.Builder>... createAccountStatuses) {
            createAccountStatuses(Stream.of(createAccountStatuses)
                    .map(c -> CreateAccountStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCreateAccountStatuses(Collection<CreateAccountStatus.BuilderImpl> createAccountStatuses) {
            this.createAccountStatuses = CreateAccountStatusesCopier.copyFromBuilder(createAccountStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCreateAccountStatusResponse build() {
            return new ListCreateAccountStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
