/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the criteria that are used to select the handshakes for the operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HandshakeFilter implements SdkPojo, Serializable, ToCopyableBuilder<HandshakeFilter.Builder, HandshakeFilter> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HandshakeFilter::actionTypeAsString)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> PARENT_HANDSHAKE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HandshakeFilter::parentHandshakeId)).setter(setter(Builder::parentHandshakeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentHandshakeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            PARENT_HANDSHAKE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionType;

    private final String parentHandshakeId;

    private HandshakeFilter(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.parentHandshakeId = builder.parentHandshakeId;
    }

    /**
     * <p>
     * Specifies the type of handshake action.
     * </p>
     * <p>
     * If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of handshake action.</p>
     *         <p>
     *         If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.
     * @see ActionType
     */
    public ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * Specifies the type of handshake action.
     * </p>
     * <p>
     * If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of handshake action.</p>
     *         <p>
     *         If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.
     * @see ActionType
     */
    public String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * Specifies the parent handshake. Only used for handshake types that are a child of another type.
     * </p>
     * <p>
     * If you specify <code>ParentHandshakeId</code>, you cannot also specify <code>ActionType</code>.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-" followed by
     * from 8 to 32 lower-case letters or digits.
     * </p>
     * 
     * @return Specifies the parent handshake. Only used for handshake types that are a child of another type.</p>
     *         <p>
     *         If you specify <code>ParentHandshakeId</code>, you cannot also specify <code>ActionType</code>.
     *         </p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-"
     *         followed by from 8 to 32 lower-case letters or digits.
     */
    public String parentHandshakeId() {
        return parentHandshakeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parentHandshakeId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeFilter)) {
            return false;
        }
        HandshakeFilter other = (HandshakeFilter) obj;
        return Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(parentHandshakeId(), other.parentHandshakeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HandshakeFilter").add("ActionType", actionTypeAsString())
                .add("ParentHandshakeId", parentHandshakeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "ParentHandshakeId":
            return Optional.ofNullable(clazz.cast(parentHandshakeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HandshakeFilter, T> g) {
        return obj -> g.apply((HandshakeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HandshakeFilter> {
        /**
         * <p>
         * Specifies the type of handshake action.
         * </p>
         * <p>
         * If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.
         * </p>
         * 
         * @param actionType
         *        Specifies the type of handshake action.</p>
         *        <p>
         *        If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * Specifies the type of handshake action.
         * </p>
         * <p>
         * If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.
         * </p>
         * 
         * @param actionType
         *        Specifies the type of handshake action.</p>
         *        <p>
         *        If you specify <code>ActionType</code>, you cannot also specify <code>ParentHandshakeId</code>.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * Specifies the parent handshake. Only used for handshake types that are a child of another type.
         * </p>
         * <p>
         * If you specify <code>ParentHandshakeId</code>, you cannot also specify <code>ActionType</code>.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-"
         * followed by from 8 to 32 lower-case letters or digits.
         * </p>
         * 
         * @param parentHandshakeId
         *        Specifies the parent handshake. Only used for handshake types that are a child of another type.</p>
         *        <p>
         *        If you specify <code>ParentHandshakeId</code>, you cannot also specify <code>ActionType</code>.
         *        </p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for handshake ID string requires "h-"
         *        followed by from 8 to 32 lower-case letters or digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentHandshakeId(String parentHandshakeId);
    }

    static final class BuilderImpl implements Builder {
        private String actionType;

        private String parentHandshakeId;

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeFilter model) {
            actionType(model.actionType);
            parentHandshakeId(model.parentHandshakeId);
        }

        public final String getActionTypeAsString() {
            return actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getParentHandshakeId() {
            return parentHandshakeId;
        }

        @Override
        public final Builder parentHandshakeId(String parentHandshakeId) {
            this.parentHandshakeId = parentHandshakeId;
            return this;
        }

        public final void setParentHandshakeId(String parentHandshakeId) {
            this.parentHandshakeId = parentHandshakeId;
        }

        @Override
        public HandshakeFilter build() {
            return new HandshakeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
