/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEffectivePolicyRequest extends OrganizationsRequest implements
        ToCopyableBuilder<DescribeEffectivePolicyRequest.Builder, DescribeEffectivePolicyRequest> {
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeEffectivePolicyRequest::policyTypeAsString)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeEffectivePolicyRequest::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_FIELD,
            TARGET_ID_FIELD));

    private final String policyType;

    private final String targetId;

    private DescribeEffectivePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyType = builder.policyType;
        this.targetId = builder.targetId;
    }

    /**
     * <p>
     * The type of policy that you want information about.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link EffectivePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy that you want information about.
     * @see EffectivePolicyType
     */
    public EffectivePolicyType policyType() {
        return EffectivePolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of policy that you want information about.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link EffectivePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy that you want information about.
     * @see EffectivePolicyType
     */
    public String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * When you're signed in as the master account, specify the ID of the account that you want details about.
     * Specifying an organization root or OU as the target is not supported.
     * </p>
     * 
     * @return When you're signed in as the master account, specify the ID of the account that you want details about.
     *         Specifying an organization root or OU as the target is not supported.
     */
    public String targetId() {
        return targetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEffectivePolicyRequest)) {
            return false;
        }
        DescribeEffectivePolicyRequest other = (DescribeEffectivePolicyRequest) obj;
        return Objects.equals(policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(targetId(), other.targetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEffectivePolicyRequest").add("PolicyType", policyTypeAsString())
                .add("TargetId", targetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEffectivePolicyRequest, T> g) {
        return obj -> g.apply((DescribeEffectivePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEffectivePolicyRequest> {
        /**
         * <p>
         * The type of policy that you want information about.
         * </p>
         * 
         * @param policyType
         *        The type of policy that you want information about.
         * @see EffectivePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectivePolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of policy that you want information about.
         * </p>
         * 
         * @param policyType
         *        The type of policy that you want information about.
         * @see EffectivePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EffectivePolicyType
         */
        Builder policyType(EffectivePolicyType policyType);

        /**
         * <p>
         * When you're signed in as the master account, specify the ID of the account that you want details about.
         * Specifying an organization root or OU as the target is not supported.
         * </p>
         * 
         * @param targetId
         *        When you're signed in as the master account, specify the ID of the account that you want details
         *        about. Specifying an organization root or OU as the target is not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private String policyType;

        private String targetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEffectivePolicyRequest model) {
            super(model);
            policyType(model.policyType);
            targetId(model.targetId);
        }

        public final String getPolicyTypeAsString() {
            return policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(EffectivePolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final String getTargetId() {
            return targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEffectivePolicyRequest build() {
            return new DescribeEffectivePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
