/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.AcceptHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.AccessDeniedException;
import software.amazon.awssdk.services.organizations.model.AccessDeniedForDependencyException;
import software.amazon.awssdk.services.organizations.model.AccountNotFoundException;
import software.amazon.awssdk.services.organizations.model.AccountOwnerNotVerifiedException;
import software.amazon.awssdk.services.organizations.model.AlreadyInOrganizationException;
import software.amazon.awssdk.services.organizations.model.AttachPolicyRequest;
import software.amazon.awssdk.services.organizations.model.AttachPolicyResponse;
import software.amazon.awssdk.services.organizations.model.AwsOrganizationsNotInUseException;
import software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.CancelHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.ChildNotFoundException;
import software.amazon.awssdk.services.organizations.model.ConcurrentModificationException;
import software.amazon.awssdk.services.organizations.model.ConstraintViolationException;
import software.amazon.awssdk.services.organizations.model.CreateAccountRequest;
import software.amazon.awssdk.services.organizations.model.CreateAccountResponse;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatusNotFoundException;
import software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountRequest;
import software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountResponse;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.CreatePolicyRequest;
import software.amazon.awssdk.services.organizations.model.CreatePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.DeclineHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.DeletePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DeletePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DescribeAccountRequest;
import software.amazon.awssdk.services.organizations.model.DescribeAccountResponse;
import software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse;
import software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.DescribeHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.DescribePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DescribePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DestinationParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.DetachPolicyRequest;
import software.amazon.awssdk.services.organizations.model.DetachPolicyResponse;
import software.amazon.awssdk.services.organizations.model.DisableAWSServiceAccessResponse;
import software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest;
import software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest;
import software.amazon.awssdk.services.organizations.model.DisablePolicyTypeResponse;
import software.amazon.awssdk.services.organizations.model.DuplicateAccountException;
import software.amazon.awssdk.services.organizations.model.DuplicateHandshakeException;
import software.amazon.awssdk.services.organizations.model.DuplicateOrganizationalUnitException;
import software.amazon.awssdk.services.organizations.model.DuplicatePolicyAttachmentException;
import software.amazon.awssdk.services.organizations.model.DuplicatePolicyException;
import software.amazon.awssdk.services.organizations.model.EnableAWSServiceAccessResponse;
import software.amazon.awssdk.services.organizations.model.EnableAllFeaturesRequest;
import software.amazon.awssdk.services.organizations.model.EnableAllFeaturesResponse;
import software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest;
import software.amazon.awssdk.services.organizations.model.EnablePolicyTypeRequest;
import software.amazon.awssdk.services.organizations.model.EnablePolicyTypeResponse;
import software.amazon.awssdk.services.organizations.model.FinalizingOrganizationException;
import software.amazon.awssdk.services.organizations.model.HandshakeAlreadyInStateException;
import software.amazon.awssdk.services.organizations.model.HandshakeConstraintViolationException;
import software.amazon.awssdk.services.organizations.model.HandshakeNotFoundException;
import software.amazon.awssdk.services.organizations.model.InvalidHandshakeTransitionException;
import software.amazon.awssdk.services.organizations.model.InvalidInputException;
import software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.LeaveOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.LeaveOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentResponse;
import software.amazon.awssdk.services.organizations.model.ListAccountsRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsResponse;
import software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListChildrenRequest;
import software.amazon.awssdk.services.organizations.model.ListChildrenResponse;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse;
import software.amazon.awssdk.services.organizations.model.ListParentsRequest;
import software.amazon.awssdk.services.organizations.model.ListParentsResponse;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse;
import software.amazon.awssdk.services.organizations.model.ListPoliciesRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesResponse;
import software.amazon.awssdk.services.organizations.model.ListRootsRequest;
import software.amazon.awssdk.services.organizations.model.ListRootsResponse;
import software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.organizations.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse;
import software.amazon.awssdk.services.organizations.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.organizations.model.MasterCannotLeaveOrganizationException;
import software.amazon.awssdk.services.organizations.model.MoveAccountRequest;
import software.amazon.awssdk.services.organizations.model.MoveAccountResponse;
import software.amazon.awssdk.services.organizations.model.OrganizationNotEmptyException;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnitNotEmptyException;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnitNotFoundException;
import software.amazon.awssdk.services.organizations.model.OrganizationsException;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.services.organizations.model.ParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.PolicyInUseException;
import software.amazon.awssdk.services.organizations.model.PolicyNotAttachedException;
import software.amazon.awssdk.services.organizations.model.PolicyNotFoundException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeAlreadyEnabledException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeNotAvailableForOrganizationException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeNotEnabledException;
import software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.RootNotFoundException;
import software.amazon.awssdk.services.organizations.model.ServiceException;
import software.amazon.awssdk.services.organizations.model.SourceParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.TagResourceRequest;
import software.amazon.awssdk.services.organizations.model.TagResourceResponse;
import software.amazon.awssdk.services.organizations.model.TargetNotFoundException;
import software.amazon.awssdk.services.organizations.model.TooManyRequestsException;
import software.amazon.awssdk.services.organizations.model.UnsupportedApiEndpointException;
import software.amazon.awssdk.services.organizations.model.UntagResourceRequest;
import software.amazon.awssdk.services.organizations.model.UntagResourceResponse;
import software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest;
import software.amazon.awssdk.services.organizations.model.UpdatePolicyResponse;
import software.amazon.awssdk.services.organizations.paginators.ListAWSServiceAccessForOrganizationIterable;
import software.amazon.awssdk.services.organizations.paginators.ListAccountsForParentIterable;
import software.amazon.awssdk.services.organizations.paginators.ListAccountsIterable;
import software.amazon.awssdk.services.organizations.paginators.ListChildrenIterable;
import software.amazon.awssdk.services.organizations.paginators.ListCreateAccountStatusIterable;
import software.amazon.awssdk.services.organizations.paginators.ListHandshakesForAccountIterable;
import software.amazon.awssdk.services.organizations.paginators.ListHandshakesForOrganizationIterable;
import software.amazon.awssdk.services.organizations.paginators.ListOrganizationalUnitsForParentIterable;
import software.amazon.awssdk.services.organizations.paginators.ListParentsIterable;
import software.amazon.awssdk.services.organizations.paginators.ListPoliciesForTargetIterable;
import software.amazon.awssdk.services.organizations.paginators.ListPoliciesIterable;
import software.amazon.awssdk.services.organizations.paginators.ListRootsIterable;
import software.amazon.awssdk.services.organizations.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.organizations.paginators.ListTargetsForPolicyIterable;
import software.amazon.awssdk.services.organizations.transform.AcceptHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.AttachPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CancelHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateGovCloudAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreatePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeclineHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeleteOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeleteOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeCreateAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DetachPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DisableAwsServiceAccessRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DisablePolicyTypeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.EnableAllFeaturesRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.EnableAwsServiceAccessRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.EnablePolicyTypeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.InviteAccountToOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.LeaveOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAccountsForParentRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAccountsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAwsServiceAccessForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListChildrenRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListCreateAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListHandshakesForAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListHandshakesForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListOrganizationalUnitsForParentRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListParentsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListPoliciesForTargetRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListPoliciesRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListRootsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListTargetsForPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.MoveAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.RemoveAccountFromOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.UpdateOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.UpdatePolicyRequestMarshaller;

@SdkInternalApi
final class DefaultOrganizationsClient
implements OrganizationsClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultOrganizationsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "organizations";
    }

    @Override
    public AcceptHandshakeResponse acceptHandshake(AcceptHandshakeRequest acceptHandshakeRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, HandshakeConstraintViolationException, HandshakeNotFoundException, InvalidHandshakeTransitionException, HandshakeAlreadyInStateException, InvalidInputException, ConcurrentModificationException, ServiceException, TooManyRequestsException, AccessDeniedForDependencyException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptHandshakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AcceptHandshakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptHandshake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptHandshakeRequest).withMarshaller((Marshaller)new AcceptHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AttachPolicyResponse attachPolicy(AttachPolicyRequest attachPolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, DuplicatePolicyAttachmentException, InvalidInputException, PolicyNotFoundException, PolicyTypeNotEnabledException, ServiceException, TargetNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AttachPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachPolicyRequest).withMarshaller((Marshaller)new AttachPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CancelHandshakeResponse cancelHandshake(CancelHandshakeRequest cancelHandshakeRequest) throws AccessDeniedException, ConcurrentModificationException, HandshakeNotFoundException, InvalidHandshakeTransitionException, HandshakeAlreadyInStateException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelHandshakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CancelHandshakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelHandshake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelHandshakeRequest).withMarshaller((Marshaller)new CancelHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateAccountResponse createAccount(CreateAccountRequest createAccountRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, FinalizingOrganizationException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAccountRequest).withMarshaller((Marshaller)new CreateAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateGovCloudAccountResponse createGovCloudAccount(CreateGovCloudAccountRequest createGovCloudAccountRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, FinalizingOrganizationException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGovCloudAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateGovCloudAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGovCloudAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGovCloudAccountRequest).withMarshaller((Marshaller)new CreateGovCloudAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateOrganizationResponse createOrganization(CreateOrganizationRequest createOrganizationRequest) throws AccessDeniedException, AlreadyInOrganizationException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AccessDeniedForDependencyException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createOrganizationRequest).withMarshaller((Marshaller)new CreateOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateOrganizationalUnitResponse createOrganizationalUnit(CreateOrganizationalUnitRequest createOrganizationalUnitRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, DuplicateOrganizationalUnitException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateOrganizationalUnitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateOrganizationalUnitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOrganizationalUnit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createOrganizationalUnitRequest).withMarshaller((Marshaller)new CreateOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreatePolicyResponse createPolicy(CreatePolicyRequest createPolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, DuplicatePolicyException, InvalidInputException, MalformedPolicyDocumentException, PolicyTypeNotAvailableForOrganizationException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreatePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPolicyRequest).withMarshaller((Marshaller)new CreatePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeclineHandshakeResponse declineHandshake(DeclineHandshakeRequest declineHandshakeRequest) throws AccessDeniedException, ConcurrentModificationException, HandshakeNotFoundException, InvalidHandshakeTransitionException, HandshakeAlreadyInStateException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeclineHandshakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeclineHandshakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeclineHandshake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)declineHandshakeRequest).withMarshaller((Marshaller)new DeclineHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteOrganizationResponse deleteOrganization(DeleteOrganizationRequest deleteOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, InvalidInputException, OrganizationNotEmptyException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteOrganizationRequest).withMarshaller((Marshaller)new DeleteOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteOrganizationalUnitResponse deleteOrganizationalUnit(DeleteOrganizationalUnitRequest deleteOrganizationalUnitRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, InvalidInputException, OrganizationalUnitNotEmptyException, OrganizationalUnitNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOrganizationalUnitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteOrganizationalUnitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOrganizationalUnit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteOrganizationalUnitRequest).withMarshaller((Marshaller)new DeleteOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, InvalidInputException, PolicyInUseException, PolicyNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeletePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePolicyRequest).withMarshaller((Marshaller)new DeletePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAccountResponse describeAccount(DescribeAccountRequest describeAccountRequest) throws AccessDeniedException, AccountNotFoundException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountRequest).withMarshaller((Marshaller)new DescribeAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeCreateAccountStatusResponse describeCreateAccountStatus(DescribeCreateAccountStatusRequest describeCreateAccountStatusRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, CreateAccountStatusNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCreateAccountStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeCreateAccountStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCreateAccountStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCreateAccountStatusRequest).withMarshaller((Marshaller)new DescribeCreateAccountStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeHandshakeResponse describeHandshake(DescribeHandshakeRequest describeHandshakeRequest) throws AccessDeniedException, ConcurrentModificationException, HandshakeNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeHandshakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeHandshakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHandshake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHandshakeRequest).withMarshaller((Marshaller)new DescribeHandshakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeOrganizationResponse describeOrganization(DescribeOrganizationRequest describeOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationRequest).withMarshaller((Marshaller)new DescribeOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeOrganizationalUnitResponse describeOrganizationalUnit(DescribeOrganizationalUnitRequest describeOrganizationalUnitRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, OrganizationalUnitNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationalUnitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeOrganizationalUnitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationalUnit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationalUnitRequest).withMarshaller((Marshaller)new DescribeOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribePolicyResponse describePolicy(DescribePolicyRequest describePolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, PolicyNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePolicyRequest).withMarshaller((Marshaller)new DescribePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DetachPolicyResponse detachPolicy(DetachPolicyRequest detachPolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, PolicyNotAttachedException, PolicyNotFoundException, ServiceException, TargetNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DetachPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachPolicyRequest).withMarshaller((Marshaller)new DetachPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisableAWSServiceAccessResponse disableAWSServiceAccess(DisableAwsServiceAccessRequest disableAwsServiceAccessRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableAWSServiceAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisableAWSServiceAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAWSServiceAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableAwsServiceAccessRequest).withMarshaller((Marshaller)new DisableAwsServiceAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisablePolicyTypeResponse disablePolicyType(DisablePolicyTypeRequest disablePolicyTypeRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, PolicyTypeNotEnabledException, RootNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisablePolicyTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisablePolicyTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisablePolicyType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disablePolicyTypeRequest).withMarshaller((Marshaller)new DisablePolicyTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public EnableAWSServiceAccessResponse enableAWSServiceAccess(EnableAwsServiceAccessRequest enableAwsServiceAccessRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableAWSServiceAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (EnableAWSServiceAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAWSServiceAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableAwsServiceAccessRequest).withMarshaller((Marshaller)new EnableAwsServiceAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public EnableAllFeaturesResponse enableAllFeatures(EnableAllFeaturesRequest enableAllFeaturesRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, HandshakeConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableAllFeaturesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (EnableAllFeaturesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAllFeatures").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableAllFeaturesRequest).withMarshaller((Marshaller)new EnableAllFeaturesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public EnablePolicyTypeResponse enablePolicyType(EnablePolicyTypeRequest enablePolicyTypeRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, PolicyTypeAlreadyEnabledException, RootNotFoundException, ServiceException, TooManyRequestsException, PolicyTypeNotAvailableForOrganizationException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnablePolicyTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (EnablePolicyTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnablePolicyType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enablePolicyTypeRequest).withMarshaller((Marshaller)new EnablePolicyTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public InviteAccountToOrganizationResponse inviteAccountToOrganization(InviteAccountToOrganizationRequest inviteAccountToOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, AccountOwnerNotVerifiedException, ConcurrentModificationException, HandshakeConstraintViolationException, DuplicateHandshakeException, InvalidInputException, FinalizingOrganizationException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InviteAccountToOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (InviteAccountToOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InviteAccountToOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)inviteAccountToOrganizationRequest).withMarshaller((Marshaller)new InviteAccountToOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public LeaveOrganizationResponse leaveOrganization(LeaveOrganizationRequest leaveOrganizationRequest) throws AccessDeniedException, AccountNotFoundException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, MasterCannotLeaveOrganizationException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LeaveOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (LeaveOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("LeaveOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)leaveOrganizationRequest).withMarshaller((Marshaller)new LeaveOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListAwsServiceAccessForOrganizationResponse listAWSServiceAccessForOrganization(ListAwsServiceAccessForOrganizationRequest listAwsServiceAccessForOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAwsServiceAccessForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListAwsServiceAccessForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAWSServiceAccessForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAwsServiceAccessForOrganizationRequest).withMarshaller((Marshaller)new ListAwsServiceAccessForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListAWSServiceAccessForOrganizationIterable listAWSServiceAccessForOrganizationPaginator(ListAwsServiceAccessForOrganizationRequest listAwsServiceAccessForOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListAWSServiceAccessForOrganizationIterable(this, this.applyPaginatorUserAgent(listAwsServiceAccessForOrganizationRequest));
    }

    @Override
    public ListAccountsResponse listAccounts(ListAccountsRequest listAccountsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccounts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccountsRequest).withMarshaller((Marshaller)new ListAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListAccountsIterable listAccountsPaginator(ListAccountsRequest listAccountsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListAccountsIterable(this, this.applyPaginatorUserAgent(listAccountsRequest));
    }

    @Override
    public ListAccountsForParentResponse listAccountsForParent(ListAccountsForParentRequest listAccountsForParentRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountsForParentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListAccountsForParentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountsForParent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccountsForParentRequest).withMarshaller((Marshaller)new ListAccountsForParentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListAccountsForParentIterable listAccountsForParentPaginator(ListAccountsForParentRequest listAccountsForParentRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListAccountsForParentIterable(this, this.applyPaginatorUserAgent(listAccountsForParentRequest));
    }

    @Override
    public ListChildrenResponse listChildren(ListChildrenRequest listChildrenRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChildrenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListChildrenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChildren").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listChildrenRequest).withMarshaller((Marshaller)new ListChildrenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListChildrenIterable listChildrenPaginator(ListChildrenRequest listChildrenRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListChildrenIterable(this, this.applyPaginatorUserAgent(listChildrenRequest));
    }

    @Override
    public ListCreateAccountStatusResponse listCreateAccountStatus(ListCreateAccountStatusRequest listCreateAccountStatusRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCreateAccountStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListCreateAccountStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCreateAccountStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCreateAccountStatusRequest).withMarshaller((Marshaller)new ListCreateAccountStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListCreateAccountStatusIterable listCreateAccountStatusPaginator(ListCreateAccountStatusRequest listCreateAccountStatusRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, UnsupportedApiEndpointException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListCreateAccountStatusIterable(this, this.applyPaginatorUserAgent(listCreateAccountStatusRequest));
    }

    @Override
    public ListHandshakesForAccountResponse listHandshakesForAccount(ListHandshakesForAccountRequest listHandshakesForAccountRequest) throws AccessDeniedException, ConcurrentModificationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHandshakesForAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListHandshakesForAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHandshakesForAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHandshakesForAccountRequest).withMarshaller((Marshaller)new ListHandshakesForAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListHandshakesForAccountIterable listHandshakesForAccountPaginator(ListHandshakesForAccountRequest listHandshakesForAccountRequest) throws AccessDeniedException, ConcurrentModificationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListHandshakesForAccountIterable(this, this.applyPaginatorUserAgent(listHandshakesForAccountRequest));
    }

    @Override
    public ListHandshakesForOrganizationResponse listHandshakesForOrganization(ListHandshakesForOrganizationRequest listHandshakesForOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHandshakesForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListHandshakesForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHandshakesForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHandshakesForOrganizationRequest).withMarshaller((Marshaller)new ListHandshakesForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListHandshakesForOrganizationIterable listHandshakesForOrganizationPaginator(ListHandshakesForOrganizationRequest listHandshakesForOrganizationRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListHandshakesForOrganizationIterable(this, this.applyPaginatorUserAgent(listHandshakesForOrganizationRequest));
    }

    @Override
    public ListOrganizationalUnitsForParentResponse listOrganizationalUnitsForParent(ListOrganizationalUnitsForParentRequest listOrganizationalUnitsForParentRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOrganizationalUnitsForParentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListOrganizationalUnitsForParentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOrganizationalUnitsForParent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOrganizationalUnitsForParentRequest).withMarshaller((Marshaller)new ListOrganizationalUnitsForParentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListOrganizationalUnitsForParentIterable listOrganizationalUnitsForParentPaginator(ListOrganizationalUnitsForParentRequest listOrganizationalUnitsForParentRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ParentNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListOrganizationalUnitsForParentIterable(this, this.applyPaginatorUserAgent(listOrganizationalUnitsForParentRequest));
    }

    @Override
    public ListParentsResponse listParents(ListParentsRequest listParentsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ChildNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListParentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListParentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListParents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listParentsRequest).withMarshaller((Marshaller)new ListParentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListParentsIterable listParentsPaginator(ListParentsRequest listParentsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ChildNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListParentsIterable(this, this.applyPaginatorUserAgent(listParentsRequest));
    }

    @Override
    public ListPoliciesResponse listPolicies(ListPoliciesRequest listPoliciesRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPoliciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPoliciesRequest).withMarshaller((Marshaller)new ListPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPoliciesIterable listPoliciesPaginator(ListPoliciesRequest listPoliciesRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListPoliciesIterable(this, this.applyPaginatorUserAgent(listPoliciesRequest));
    }

    @Override
    public ListPoliciesForTargetResponse listPoliciesForTarget(ListPoliciesForTargetRequest listPoliciesForTargetRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TargetNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPoliciesForTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPoliciesForTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPoliciesForTarget").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPoliciesForTargetRequest).withMarshaller((Marshaller)new ListPoliciesForTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPoliciesForTargetIterable listPoliciesForTargetPaginator(ListPoliciesForTargetRequest listPoliciesForTargetRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TargetNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListPoliciesForTargetIterable(this, this.applyPaginatorUserAgent(listPoliciesForTargetRequest));
    }

    @Override
    public ListRootsResponse listRoots(ListRootsRequest listRootsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRootsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListRootsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRoots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRootsRequest).withMarshaller((Marshaller)new ListRootsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRootsIterable listRootsPaginator(ListRootsRequest listRootsRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListRootsIterable(this, this.applyPaginatorUserAgent(listRootsRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, TargetNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, TargetNotFoundException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    @Override
    public ListTargetsForPolicyResponse listTargetsForPolicy(ListTargetsForPolicyRequest listTargetsForPolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, PolicyNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTargetsForPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTargetsForPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTargetsForPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTargetsForPolicyRequest).withMarshaller((Marshaller)new ListTargetsForPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTargetsForPolicyIterable listTargetsForPolicyPaginator(ListTargetsForPolicyRequest listTargetsForPolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, InvalidInputException, PolicyNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        return new ListTargetsForPolicyIterable(this, this.applyPaginatorUserAgent(listTargetsForPolicyRequest));
    }

    @Override
    public MoveAccountResponse moveAccount(MoveAccountRequest moveAccountRequest) throws AccessDeniedException, InvalidInputException, SourceParentNotFoundException, DestinationParentNotFoundException, DuplicateAccountException, AccountNotFoundException, TooManyRequestsException, ConcurrentModificationException, AwsOrganizationsNotInUseException, ServiceException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MoveAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (MoveAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MoveAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)moveAccountRequest).withMarshaller((Marshaller)new MoveAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RemoveAccountFromOrganizationResponse removeAccountFromOrganization(RemoveAccountFromOrganizationRequest removeAccountFromOrganizationRequest) throws AccessDeniedException, AccountNotFoundException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, InvalidInputException, MasterCannotLeaveOrganizationException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveAccountFromOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RemoveAccountFromOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveAccountFromOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeAccountFromOrganizationRequest).withMarshaller((Marshaller)new RemoveAccountFromOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException, ConcurrentModificationException, AwsOrganizationsNotInUseException, TargetNotFoundException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException, ConcurrentModificationException, AwsOrganizationsNotInUseException, TargetNotFoundException, ConstraintViolationException, InvalidInputException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateOrganizationalUnitResponse updateOrganizationalUnit(UpdateOrganizationalUnitRequest updateOrganizationalUnitRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, DuplicateOrganizationalUnitException, InvalidInputException, OrganizationalUnitNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateOrganizationalUnitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateOrganizationalUnitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOrganizationalUnit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateOrganizationalUnitRequest).withMarshaller((Marshaller)new UpdateOrganizationalUnitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdatePolicyResponse updatePolicy(UpdatePolicyRequest updatePolicyRequest) throws AccessDeniedException, AwsOrganizationsNotInUseException, ConcurrentModificationException, ConstraintViolationException, DuplicatePolicyException, InvalidInputException, MalformedPolicyDocumentException, PolicyNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, OrganizationsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdatePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePolicyRequest).withMarshaller((Marshaller)new UpdatePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(OrganizationsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeNotAvailableForOrganizationException").exceptionBuilderSupplier(PolicyTypeNotAvailableForOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HandshakeNotFoundException").exceptionBuilderSupplier(HandshakeNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateAccountException").exceptionBuilderSupplier(DuplicateAccountException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateHandshakeException").exceptionBuilderSupplier(DuplicateHandshakeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatePolicyException").exceptionBuilderSupplier(DuplicatePolicyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HandshakeAlreadyInStateException").exceptionBuilderSupplier(HandshakeAlreadyInStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChildNotFoundException").exceptionBuilderSupplier(ChildNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountOwnerNotVerifiedException").exceptionBuilderSupplier(AccountOwnerNotVerifiedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceException").exceptionBuilderSupplier(ServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedAPIEndpointException").exceptionBuilderSupplier(UnsupportedApiEndpointException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RootNotFoundException").exceptionBuilderSupplier(RootNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationNotEmptyException").exceptionBuilderSupplier(OrganizationNotEmptyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationalUnitNotFoundException").exceptionBuilderSupplier(OrganizationalUnitNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").exceptionBuilderSupplier(PolicyNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeAlreadyEnabledException").exceptionBuilderSupplier(PolicyTypeAlreadyEnabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedForDependencyException").exceptionBuilderSupplier(AccessDeniedForDependencyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatePolicyAttachmentException").exceptionBuilderSupplier(DuplicatePolicyAttachmentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MasterCannotLeaveOrganizationException").exceptionBuilderSupplier(MasterCannotLeaveOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DestinationParentNotFoundException").exceptionBuilderSupplier(DestinationParentNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeNotEnabledException").exceptionBuilderSupplier(PolicyTypeNotEnabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConstraintViolationException").exceptionBuilderSupplier(ConstraintViolationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TargetNotFoundException").exceptionBuilderSupplier(TargetNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWSOrganizationsNotInUseException").exceptionBuilderSupplier(AwsOrganizationsNotInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CreateAccountStatusNotFoundException").exceptionBuilderSupplier(CreateAccountStatusNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyNotAttachedException").exceptionBuilderSupplier(PolicyNotAttachedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyInOrganizationException").exceptionBuilderSupplier(AlreadyInOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountNotFoundException").exceptionBuilderSupplier(AccountNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceParentNotFoundException").exceptionBuilderSupplier(SourceParentNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParentNotFoundException").exceptionBuilderSupplier(ParentNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateOrganizationalUnitException").exceptionBuilderSupplier(DuplicateOrganizationalUnitException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHandshakeTransitionException").exceptionBuilderSupplier(InvalidHandshakeTransitionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HandshakeConstraintViolationException").exceptionBuilderSupplier(HandshakeConstraintViolationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyInUseException").exceptionBuilderSupplier(PolicyInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FinalizingOrganizationException").exceptionBuilderSupplier(FinalizingOrganizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationalUnitNotEmptyException").exceptionBuilderSupplier(OrganizationalUnitNotEmptyException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends OrganizationsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.10").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((OrganizationsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

