/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.PolicyTypeSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PolicyTypeSummaryMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final PolicyTypeSummaryMarshaller INSTANCE = new PolicyTypeSummaryMarshaller();

    private PolicyTypeSummaryMarshaller() {
    }

    public static PolicyTypeSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PolicyTypeSummary policyTypeSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)policyTypeSummary, (String)"policyTypeSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)policyTypeSummary.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)policyTypeSummary.statusString(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

