/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.HandshakeFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HandshakeFilterMarshaller {
    private static final MarshallingInfo<String> ACTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionType").isBinary(false).build();
    private static final MarshallingInfo<String> PARENTHANDSHAKEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentHandshakeId").isBinary(false).build();
    private static final HandshakeFilterMarshaller INSTANCE = new HandshakeFilterMarshaller();

    private HandshakeFilterMarshaller() {
    }

    public static HandshakeFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HandshakeFilter handshakeFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)handshakeFilter, (String)"handshakeFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)handshakeFilter.actionTypeString(), ACTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)handshakeFilter.parentHandshakeId(), PARENTHANDSHAKEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

