/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse;

public class ListTargetsForPolicyIterable
implements SdkIterable<ListTargetsForPolicyResponse> {
    private final OrganizationsClient client;
    private final ListTargetsForPolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTargetsForPolicyIterable(OrganizationsClient client, ListTargetsForPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTargetsForPolicyResponseFetcher();
    }

    public Iterator<ListTargetsForPolicyResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListTargetsForPolicyIterable resume(ListTargetsForPolicyResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTargetsForPolicyIterable(this.client, (ListTargetsForPolicyRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTargetsForPolicyIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTargetsForPolicyResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTargetsForPolicyResponseFetcher
    implements SyncPageFetcher<ListTargetsForPolicyResponse> {
        private ListTargetsForPolicyResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetsForPolicyResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTargetsForPolicyResponse nextPage(ListTargetsForPolicyResponse previousPage) {
            if (previousPage == null) {
                return ListTargetsForPolicyIterable.this.client.listTargetsForPolicy(ListTargetsForPolicyIterable.this.firstRequest);
            }
            return ListTargetsForPolicyIterable.this.client.listTargetsForPolicy((ListTargetsForPolicyRequest)((Object)ListTargetsForPolicyIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

